"use strict";

// Class definition
var ThemeScripts = function () {

    // Declare variables here
    // ...
    var balanceContainer = 'balanceContainer',
        remoteAJAXFunctions = {
            loadBalance: 'ApiData/getBalance',
        };

    // Components
    var main = function() {

        // Reload the user balance every thirty (30) minutes
        setInterval(function() {
            
            // Call the function
            // reloadBalance();
            $('#' +  balanceContainer).load(remoteAJAXFunctions.loadBalance);

        // }, 30000);
        }, 60000);

    };


    /**
     * RELOAD A CLIENT ACCOUNT
     */
    var _reloading = function() {


        // Set all the required data
        var formModalID = 'reloadingFormModal',
            dtButtons = {
                add: 'reloadingFormAdd',
                edit: 'reloadingFormEdit',
            },
            remoteAJAXFunctions = {
                form: 'customers/reloadingForm',
            },
            hiddenInputs = {
                customerID: 'hidden-data-customer-ID'
            };



        // Function to load on (edit or add) button click
        $(document).on('click', '#' + dtButtons.edit + ', #' + dtButtons.add + ', .' + dtButtons.add, function() {

            // Test
            // ...
            // console.log('hello from scripts.js');

            // Get the selected row id
            let rowID = $(this).attr('data-row-id');
            let packID = $(this).attr('data-pack-ID');
            // let customerID = ($(this).attr('data-customer-ID')) ? parseInt($(this).attr('data-customer-ID')) : 0;
            // let customerID = $(this).attr('data-customer-ID');


            // Test
            // ...
            // console.log('rowID ' + rowID);
            // console.log('packID ' + packID);
            // console.log('customerID ' + customerID);


            // Process only if there is customer ID specified
            // if(customerID !== 0) {
            // if(customerID !== undefined) {

            //     // Update the hidden customer ID value
            //     $('#' + hiddenInputs.customerID).val(customerID);

            // } // End if

            // AJAX function to load the form data to display
            $.ajax({

                // AJAX Call options
                url: ADMIN_BASE_URL + '/' + LOCALE + '/' + remoteAJAXFunctions.form,
                type: "POST",
                data: {
                    'id': rowID,
                    'packID': packID,
                },

                // On 'Success' Event
                success: function(data) {

                    // Process only if any data has been loaded
                    if(data) {

                        // Display the loaded data
                        $('#' + formModalID + ' #mainContent').html(data);

                    } // End if

                }, // End success event

            });

        });

    };

	return {
		// public functions
		init: function() {
			main(); // Init all the form components
            // _historyDT(); // Init the history dataTable

            _reloading(); // Init all the reloading scripts actions
		}
	};
}();

jQuery(document).ready(function() {
	ThemeScripts.init();
});