"use strict";

// Class definition
var KTProfile = function () {
	// Elements
	var avatar;
	var offcanvas;

	// Private functions
	var _initAside = function () {
		// Mobile offcanvas for mobile mode
		offcanvas = new KTOffcanvas('kt_profile_aside', {
            overlay: true,
            baseClass: 'offcanvas-mobile',
            toggleBy: 'kt_subheader_mobile_toggle'
        });
	}

	var _initForm = function() {
		avatar = new KTImageInput('kt_profile_avatar');
	}

    /**
     * ALL THE PROFLE FUNCTION
     */
    var _main = function(e) {

        // Set all the required variables for the following methods
        var profileFormContainerID = 'personalInfos',
            profileFormID = 'profileForm',
            profileButtons = {
                submit: 'profileFormSubmit',
            },
            passwdFormContainerID = 'password',
            passwdFormID = 'passwordForm',
            passwdButtons = {
                submit: 'passwordFormSubmit',
            },
            remoteAJAXFunctions = {
                setProfileForm: LOCALE + '/profile/set',
                setPasswdForm: LOCALE + '/passwd/set',
            };

        // Validation rules object
        var profileValidation;
        var profileValidationForm = KTUtil.getById(profileFormID);

        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
        profileValidation = FormValidation.formValidation(
            profileValidationForm,
            {
                fields: {
                    'txt-first-name': {
                        validators: {
                            notEmpty: {
                                message: ucfirst(LANG_FILE.page.profile.field.firstName.validation.required)
                            },
                            stringLength: {
                                min:2,
                                message: ucfirst(LANG_FILE.page.profile.field.firstName.description)
                            }
                        }
                    },
                    'txt-last-name': {
                        validators: {
                            notEmpty: {
                                message: ucfirst(LANG_FILE.page.profile.field.lastName.validation.required)
                            },
                            stringLength: {
                                min:2,
                                message: ucfirst(LANG_FILE.page.profile.field.lastName.description)
                            }
                        }
                    },
                    'txt-email': {
                        validators: {
                            notEmpty: {
                                message: ucfirst(LANG_FILE.page.profile.field.email.validation.required)
                            },
                            emailAddress: {
                                message: ucfirst(LANG_FILE.page.profile.field.email.validation.valid)
                            }
                        }
                    },
                    'txt-phone': {
                        validators: {
                            notEmpty: {
                                message: ucfirst(LANG_FILE.page.profile.field.phone.validation.required)
                            },
                            digits: {
                                message: ucfirst(LANG_FILE.page.profile.field.phone.validation.digits)
                            }
                        }
                    },
                },
                plugins: {
                    trigger: new FormValidation.plugins.Trigger(),
                    bootstrap: new FormValidation.plugins.Bootstrap()
                }
            }
        );

        // Submit the profile form on footer submit button click
        $(document).on('click', '#' + profileButtons.submit , function() {

            // Submit the form
            $('#' + profileFormID).trigger('submit');

        });

        // Hold then process the form submit event
        $(document).on('submit', '#' + profileFormID, function(e) {

            // Prevent the default form submit behaviour
            e.preventDefault();

            // Submit the form only if the profileValidation is okay
            profileValidation.validate().then(function(status) {

                if (status == 'Valid') {

                    // Fire the form submit function
                    submitProfileForm();

                } else { // End if

                    // Set the toast options
                    toastr.options = {
                      "closeButton": true,
                      "debug": false,
                      "newestOnTop": true,
                      "progressBar": false,
                      "positionClass": "toast-top-right",
                      "preventDuplicates": false,
                      "onclick": null,
                      "showDuration": "300",
                      "hideDuration": "1000",
                      "timeOut": "7000",
                      "extendedTimeOut": "600",
                      "showEasing": "swing",
                      "hideEasing": "linear",
                      "showMethod": "fadeIn",
                      "hideMethod": "fadeOut"
                    };

                    // Push the server response as toast
                    toastr.error(ucfirst(LANG_FILE.general.response.errorsOccurred));

                } // End else

            });

        });

        function submitProfileForm() {

            // Call a block UI
            KTApp.block('#' + profileFormContainerID, {
                overlayColor: '#000000',
                state: 'warning',
                message: ucfirst(LANG_FILE.general.action.processing)
            });

            // Get all the required data
            var formElement = $('#' + profileFormID),
                formData = new FormData(formElement[0]);

            // AJAX Function to post the form data to database
            $.ajax({

                // AJAX Call options
                url: remoteAJAXFunctions.setProfileForm,
                type: 'POST',
                processData: false,
                contentType: false,
                data: formData,

                // On 'Success' Event
                success: function(data) {

                    // Set the toast options
                    toastr.options = {
                      "closeButton": true,
                      "debug": false,
                      "newestOnTop": true,
                      "progressBar": false,
                      "positionClass": "toast-top-right",
                      "preventDuplicates": false,
                      "onclick": null,
                      "showDuration": "300",
                      "hideDuration": "1000",
                      "timeOut": "7000",
                      "extendedTimeOut": "600",
                      "showEasing": "swing",
                      "hideEasing": "linear",
                      "showMethod": "fadeIn",
                      "hideMethod": "fadeOut"
                    };

                    // Unblock the content
                    KTApp.unblock('#' + profileFormContainerID);

                    // Get the data value
                    let serverResponse = data;

                    // Check the response code
                    if(serverResponse.code === 'success')
                    {

                        // Push the server response as toast
                        toastr.success(serverResponse.message);

                        // Reload the location
                        location.reload();

                    } // End if
                    else if(serverResponse.code === 'warning')
                    {

                        // Push the server response as toast
                        toastr.warning(serverResponse.message);

                    } // End else if
                    else
                    {

                        // Push the server response as toast
                        toastr.error(serverResponse.message);

                    } // End else

                }, // End Success Event
            });

        } // End function

        // Validation rules object
        var passwdValidation;
        var passwdValidationForm = KTUtil.getById(passwdFormID);

        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
        passwdValidation = FormValidation.formValidation(
            passwdValidationForm,
            {
                fields: {
                    'txt-current': {
                        validators: {
                            notEmpty: {
                                message: ucfirst(LANG_FILE.page.profile.field.password.validation.required)
                            }
                        }
                    },
                    'txt-new': {
                        validators: {
                            notEmpty: {
                                message: ucfirst(LANG_FILE.page.profile.field.newPassword.validation.required)
                            }
                        }
                    },
                    'txt-confirm': {
                        validators: {
                            notEmpty: {
                                message: ucfirst(LANG_FILE.page.profile.field.confirmPassword.validation.required)
                            },
                            identical: {
                                compare: function() {
                                    return passwdValidationForm.querySelector('[name="txt-new"]').value;
                                },
                                message: ucfirst(LANG_FILE.page.profile.field.confirmPassword.validation.match)
                            }
                        }
                    }
                },
                plugins: {
                    trigger: new FormValidation.plugins.Trigger(),
                    bootstrap: new FormValidation.plugins.Bootstrap()
                }
            }
        );

        // Submit the passwd form on footer submit button click
        $(document).on('click', '#' + passwdButtons.submit , function() {

            // Submit the form
            $('#' + passwdFormID).trigger('submit');

        });

        // Hold then process the form submit event
        $(document).on('submit', '#' + passwdFormID, function(elm) {

            // Prevent the default form submit behaviour
            elm.preventDefault();

            // Submit the form only if the passwdValidation is okay
            passwdValidation.validate().then(function(status) {

                if (status == 'Valid') {

                    // Fire the form submit function
                    submitPasswdForm();

                } else { // End if

                    // Set the toast options
                    toastr.options = {
                      "closeButton": true,
                      "debug": false,
                      "newestOnTop": true,
                      "progressBar": false,
                      "positionClass": "toast-top-right",
                      "preventDuplicates": false,
                      "onclick": null,
                      "showDuration": "300",
                      "hideDuration": "1000",
                      "timeOut": "7000",
                      "extendedTimeOut": "600",
                      "showEasing": "swing",
                      "hideEasing": "linear",
                      "showMethod": "fadeIn",
                      "hideMethod": "fadeOut"
                    };

                    // Push the server response as toast
                    toastr.error(ucfirst(LANG_FILE.general.response.errorsOccurred));

                } // End else

            });

        });

        function submitPasswdForm() {

            // Call a block UI
            KTApp.block('#' + passwdFormContainerID, {
                overlayColor: '#000000',
                state: 'warning',
                message: ucfirst(LANG_FILE.general.action.processing)
            });

            // Get all the required data
            var formElement = $('#' + passwdFormID),
                formData = new FormData(formElement[0]);

            // AJAX Function to post the form data to database
            $.ajax({

                // AJAX Call options
                url: remoteAJAXFunctions.setPasswdForm,
                type: 'POST',
                processData: false,
                contentType: false,
                data: formData,

                // On 'Success' Event
                success: function(data) {

                    // Set the toast options
                    toastr.options = {
                      "closeButton": true,
                      "debug": false,
                      "newestOnTop": true,
                      "progressBar": false,
                      "positionClass": "toast-top-right",
                      "preventDuplicates": false,
                      "onclick": null,
                      "showDuration": "300",
                      "hideDuration": "1000",
                      "timeOut": "7000",
                      "extendedTimeOut": "600",
                      "showEasing": "swing",
                      "hideEasing": "linear",
                      "showMethod": "fadeIn",
                      "hideMethod": "fadeOut"
                    };

                    // Unblock the content
                    KTApp.unblock('#' + passwdFormContainerID);

                    // Get the data value
                    let serverResponse = data;

                    // Check the response code
                    if(serverResponse.code === 'success')
                    {

                        // Push the server response as toast
                        toastr.success(serverResponse.message);

                        // Reload the location
                        window.location.replace(LOCALE + '/sign/out');

                    } // End if
                    else if(serverResponse.code === 'warning')
                    {

                        // Push the server response as toast
                        toastr.warning(serverResponse.message);

                    } // End else if
                    else
                    {

                        // Push the server response as toast
                        toastr.error(serverResponse.message);

                    } // End else

                }, // End Success Event
            });

        } // End function

    } // End function

	return {
		// public functions
		init: function() {
			_initAside();
			_initForm();

            _main(); // Main profile jQuery functions
		}
	};
}();

jQuery(document).ready(function() {
	KTProfile.init();
});
