"use strict";
// Class definition

var usersDataTableCRUD = function() {
    // Private functions

    // Begin Function
    var _main = function() {

        // Set all the required variables for the following methods
        var formModalID = 'userFormModal',
            formID = 'userForm',
            dtID = 'usersDatatable',
            dtSearchText = 'usersDatatableSearchQuery',
            dtSearchStatus = 'usersDatatableSearchStatus',
            dtButtons = {
                set: 'userForm',
                status: 'userStatus',
                delete: 'userFormDelete',
                reload: 'reloadDatatable',
            },
            remoteAJAXFunctions = {
                loadData: 'users/data',
                form: 'user/form',
                setForm: 'user/set',
                status: 'user/status',
                delete: 'user/delete',
            };

        // DataTable for data rows display
        var datatable = $('#' + dtID).KTDatatable({
            // datasource definition
            data: {
                type: 'remote',
                source: {
                    read: {
                        url: BASE_URL + '/' + LOCALE + '/' + remoteAJAXFunctions.loadData, // Remote JSON data source
                        map: function(raw) {
                            // sample data mapping
                            var dataSet = raw;
                            if (typeof raw.data !== 'undefined') {
                                dataSet = raw.data;
                            }
                            return dataSet;
                        },
                    },
                },
                pageSize: 10,
                serverPaging: true,
                serverFiltering: true,
                serverSorting: false,
            },

            // layout definition
            layout: {
                scroll: false,
                footer: false,
            },

            // column sorting
            sortable: true,

            pagination: true,

            search: {
                input: $('#' + dtSearchText),
                key: 'generalSearch'
            },

            // columns definition
            columns: [{
                field: 'first_name',
                title: LANG_FILE.page.users.column.user,
                width: 150,
                template: function(row) {
                    return '<a href="javascript:;" data-toggle="modal" data-target="#' + formModalID + '" data-row-id="' + row.id + '" class="navi-link ' + dtButtons.set + '">\
                                <span class="navi-text">' + row.firstName + ' ' + row.lastName + '</span>\
                            </a>';
                },
            }, {
                field: 'email',
                title: LANG_FILE.page.users.column.email,
                width: 200,
            }, {
                field: 'role',
                title: LANG_FILE.page.users.column.role,
                width: 150,
                template: function(row) {
                    return '<span class="text-info">' + row.role.name + '</span>';
                    // return (row.role && role.role.name) ? '<span class="text-info">' + row.role.name + '</span>' : 'Aucun';
                },
            }, {
                field: 'created_at',
                title: LANG_FILE.general.column.createdAT,
                width: 130,
            }, {
                field: 'active',
                title: LANG_FILE.general.column.status,
                width: 80,
                // callback function support for column rendering
                template: function(row) {
                    var status = {
                        1: {
                            'title': ucfirst(LANG_FILE.general.filter.active),
                            'class': ' label-light-success'
                        },
                        0: {
                            'title': ucfirst(LANG_FILE.general.filter.inactive),
                            'class': ' label-light-warning'
                        },
                    };

                    // Return the formated data
                    return '<span class="label font-weight-bold label-lg ' + status[row.active].class + ' label-inline">' + status[row.active].title + '</span>';
                },
            }, {
                field: '',
                title: LANG_FILE.general.column.actions,
                sortable: false,
                width: 70,
                overflow: 'visible',
                autoHide: false,
                template: function(row) {

                    // Set all the states text value
                    let statusArray = {
                        0: {
                            'text': ucfirst(LANG_FILE.general.action.enable),
                            'value': 1,
                            'icon': 'la la-check-double',
                            'className': 'text-success'
                        },
                        1: {
                            'text': ucfirst(LANG_FILE.general.action.disable),
                            'value': 0,
                            'icon': 'la la-times',
                            'className': 'text-warning'
                        }
                    };

                    let updateBTN = '<li class="navi-item"><a href="javascript:;" data-toggle="modal" data-target="#' + formModalID + '" data-row-ID="' + row.id + '" class="navi-link ' + dtButtons.set + '"><span class="navi-icon"><i class="la la-edit text-warning"></i></span><span class="navi-text">' + ucfirst(LANG_FILE.general.action.edit) + '</span></a></li>';

                    let statusBTN = '<li class="navi-item"><a href="javascript:;" class="navi-link ' + dtButtons.status + '" data-row-ID="' + row.id + '" data-row-status="' + statusArray[row.active].value + '"><span class="navi-icon"><i class="' + statusArray[row.active].icon + ' ' + statusArray[row.active].className + '"></i></span><span class="navi-text">' + statusArray[row.active].text + '</span></a></li>';

                    let removeBTN = '<li class="navi-item"><a href="javascript:;" data-row-ID="' + row.id + '" class="navi-link ' + dtButtons.delete + '"><span class="navi-icon"><i class="la la-remove text-danger"></i></span><span class="navi-text">' + ucfirst(LANG_FILE.general.action.delete) + '</span></a></li>';

                    // Return the actions dropdown button
                    return '\
                        <div class="dropdown dropdown-inline">\
                            <a href="javascript:;" class="btn btn-sm btn-clean btn-icon mr-2" data-toggle="dropdown">\
                                <span class="svg-icon svg-icon-md svg-icon-primary">\
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">\
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\
                                            <rect x="0" y="0" width="24" height="24"/>\
                                            <path d="M7,3 L17,3 C19.209139,3 21,4.790861 21,7 C21,9.209139 19.209139,11 17,11 L7,11 C4.790861,11 3,9.209139 3,7 C3,4.790861 4.790861,3 7,3 Z M7,9 C8.1045695,9 9,8.1045695 9,7 C9,5.8954305 8.1045695,5 7,5 C5.8954305,5 5,5.8954305 5,7 C5,8.1045695 5.8954305,9 7,9 Z" fill="#000000"/>\
                                            <path d="M7,13 L17,13 C19.209139,13 21,14.790861 21,17 C21,19.209139 19.209139,21 17,21 L7,21 C4.790861,21 3,19.209139 3,17 C3,14.790861 4.790861,13 7,13 Z M17,19 C18.1045695,19 19,18.1045695 19,17 C19,15.8954305 18.1045695,15 17,15 C15.8954305,15 15,15.8954305 15,17 C15,18.1045695 15.8954305,19 17,19 Z" fill="#000000" opacity="0.3"/>\
                                        </g>\
                                    </svg>\
                                </span>\
                            </a>\
                            <div class="dropdown-menu dropdown-menu-sm dropdown-menu-right">\
                                <ul class="navi flex-column navi-hover py-2">\
                                    ' + updateBTN + '\
                                    ' + statusBTN + '\
                                    ' + removeBTN + '\
                                </ul>\
                            </div>\
                        </div>\
                    ';
                },
            }],

        });

        // Filter the row by status ('active' field)
		$('#' + dtSearchStatus).on('change', function() {

            // Search value within 'active' field
            datatable.search($(this).val().toLowerCase(), 'active');

        });

        // Search actions ...
        $('#' + dtSearchStatus + ', #' + dtSearchText).selectpicker();

        // Reload the datatable on 'ReloadButton' click
        $(document).on('click', '#' + dtButtons.reload, function() {

            // Reload the datatable
            $('#' + dtID).KTDatatable('reload');

        });

        // Function to load on (edit or add) button click
        $(document).on('click', '.' + dtButtons.set, function() {

            // Get the selected row id
            var rowID = $(this).attr('data-row-ID');

            // AJAX function to load the form data to display
            $.ajax({

                // AJAX Call options
                url: BASE_URL + '/' + LOCALE + '/' + remoteAJAXFunctions.form,
                type: "POST",
                data: {
                    'rowID': rowID,
                },

                // On 'Success' Event
                success: function(data) {

                    // Process only if any data has been loaded
                    if(data) {

                        // Display the loaded data
                        $('#' + formModalID + ' #mainContent').html(data);

                    } // End if

                }, // End success event

            });

        });

        /**
         * PROCESS FORM
         * On click on the 'submit' button
         * 
         * @param formData
         * 
         * @return toast
         */
        $(document).on('submit', '#' + formModalID + ' form', function(e) {

            // Call a block UI
            KTApp.block('#' + formModalID + ' form', {
                overlayColor: '#000000',
                state: 'warning',
                message: ucfirst(LANG_FILE.general.action.processing)
            });

            // Prevent the default form submit behaviour
            e.preventDefault();

            // Get all the required data
            var formElement = $('#' + formID),
                formData = new FormData(formElement[0]);

            // AJAX Function to post the form data to database
            $.ajax({

                // AJAX Call options
                url: BASE_URL + '/' + LOCALE + '/' + remoteAJAXFunctions.setForm,
                type: 'POST',
                processData: false,
                contentType: false,
                data: formData,

                // On 'Success' Event
                success: function(data) {

                    // Set the toast options
                    toastr.options = {
                      "closeButton": true,
                      "debug": false,
                      "newestOnTop": true,
                      "progressBar": false,
                      "positionClass": "toast-top-right",
                      "preventDuplicates": false,
                      "onclick": null,
                      "showDuration": "300",
                      "hideDuration": "1000",
                      "timeOut": "7000",
                      "extendedTimeOut": "600",
                      "showEasing": "swing",
                      "hideEasing": "linear",
                      "showMethod": "fadeIn",
                      "hideMethod": "fadeOut"
                    };

                    // Unblock the content
                    KTApp.unblock('#' + formModalID + ' form');

                    // Get the data value
                    let serverResponse = data;

                    // Check the response code
                    if(serverResponse.code === 'success')
                    {

                        // Dismiss the form modal
                        $('#' + formModalID).modal('hide');

                        // Push the server response as toast
                        toastr.success(serverResponse.message);

                        // Reload the datatable
                        $('#' + dtID).KTDatatable('reload');

                    } // End if
                    else if(serverResponse.code === 'warning')
                    {

                        // Push the server response as toast
                        toastr.warning(serverResponse.message);

                    } // End else if
                    else
                    {

                        // Push the server response as toast
                        toastr.error(serverResponse.message);

                    } // End else

                }, // End Success Event
            });

        });

        /**
         * ENABLE / DISABLE ROW
         * On click on the 'status' button
         * 
         * @param node_element
         * 
         * @return toast
         */
        $(document).on('click', '.' + dtButtons.status, function() {

            // Get the selected row id
            let actionTitle = ucfirst(LANG_FILE.general.action.updating);
            let rowID = $(this).attr('data-row-ID');
            let status = $(this).attr('data-row-status');

            // Set all the states text value
            let statusArray = {
                1: {
                    'text': ucfirst(LANG_FILE.general.action.enable),
                    'className': 'btn btn-success',
                },
                0: {
                    'text': ucfirst(LANG_FILE.general.action.disable),
                    'className': 'btn btn-warning',
                }
            };

            // Swal Pop-Up to confirm or cancel delete action
            Swal.fire({
                title: ucfirst(LANG_FILE.general.action.confirmAction),
                text: ucfirst(LANG_FILE.general.action.alertStatus),
                showCancelButton: true,
                confirmButtonText: ucfirst(LANG_FILE.general.action.yes) + ", " + statusArray[status].text + " !",
                cancelButtonText: ucfirst(LANG_FILE.general.action.notConfirmed),
                buttonsStyling: false,
                customClass: {
                    confirmButton: statusArray[status].className,
                    cancelButton: "btn btn-secondary",
                },
                reverseButtons: true,
            }).then(function(result) {

                // Process only if 'confirm' button is clicked
                if (result.value) {

                    // AJAX function to delete the data from server
                    $.ajax({

                        // AJAX Call options
                        url: BASE_URL + '/' + LOCALE + '/' + remoteAJAXFunctions.status,
                        type: 'POST',
                        data: {
                            'rowID': rowID,
                            'status': status,
                        },

                        // On 'Success' Event
                        success: function(data) {

                            // Get the data value
                            let serverResponse = data;

                            // Return the processing response to the user
                            Swal.fire(
                                actionTitle,
                                serverResponse.message,
                                serverResponse.code,
                            );

                        }, // End Success Event
                    });

                    // Reload the datatable
                    $('#' + dtID).KTDatatable('reload');

                } // End if
            });
        });

        /**
         * DELETE ROW
         * On click on the 'delete' button
         * 
         * @param node_element
         * 
         * @return toast
         */
        $(document).on('click', '.' + dtButtons.delete, function() {

            // Get the selected row id
            var rowID = $(this).attr('data-row-ID');

            // Swal Pop-Up to confirm or cancel delete action
            Swal.fire({
                title: ucfirst(LANG_FILE.general.action.confirmAction),
                text: ucfirst(LANG_FILE.general.action.alertDelete),
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: ucfirst(LANG_FILE.general.action.confirmDelete),
                cancelButtonText: ucfirst(LANG_FILE.general.action.notConfirmed),
                buttonsStyling: false,
                customClass: {
                    confirmButton: "btn btn-danger",
                    cancelButton: "btn btn-secondary",
                },
                reverseButtons: true,
            }).then(function(result) {

                // Process only if 'confirm' button is clicked
                if (result.value) {

                    // AJAX function to delete the data from server
                    $.ajax({

                        // AJAX Call options
                        url: BASE_URL + '/' + LOCALE + '/' + remoteAJAXFunctions.delete,
                        type: 'POST',
                        data: {
                            'rowID': rowID,
                        },

                        // On 'Success' Event
                        success: function(data) {

                            // Get the data value
                            let serverResponse = data;

                            // Return the processing response to the user
                            Swal.fire(
                                ucfirst(LANG_FILE.general.action.deletion),
                                serverResponse.message,
                                serverResponse.code,
                            );

                        }, // End Success Event
                    });

                    // Reload the datatable
                    $('#' + dtID).KTDatatable('reload');

                } // End if
            });
        });

    }; // End Function

    return {
        // public functions
        init: function() {
            _main();
        },
    };
}();

jQuery(document).ready(function() {
    usersDataTableCRUD.init();
});