<?php

// Test
// ...
// var_dump($profile);
// var_dump($pageDetails);
// var_dump($partials);
// var_dump($account);
// exit;

/* Set the page tabs details */
$tab = [
    'details'   => 'tabDetails',
    'password'  => 'tabPassword',
];

// Get all the required informations
$userFirstName = (! empty($profile['firstName'])) ? $profile['firstName'] : '';
$userLastName = (! empty($profile['lastName'])) ? $profile['lastName'] : '';
$userEmail = (! empty($profile['email'])) ? $profile['email'] : '';
$userPhone = (! empty($profile['phone'])) ? $profile['phone'] : '';
$userRole = (! empty($profile['role'])) ? $profile['role'] : '';
$userPhoto = (! empty($profile['photo'])) ? $profile['photo'] : '';

// Get any sent alert message
$alertMessage = (! empty($alertMessage)) ? $alertMessage : [];

?>

<!--begin::Card-->
<div class="card card-custom gutter-b">
    <div class="card-body">

        <?php

        // Process only if there is a message to display
        if(! empty($alertMessage))
        {

        ?>
        <!--begin::ProcessingAlerts-->
        <div class="alert alert-custom alert-outline-2x alert-outline-<?= $alertMessage['type']; ?> fade show mb-5" role="alert">
            <div class="alert-icon"><i class="flaticon-<?= $alertMessage['icon']; ?>"></i></div>
            <div class="alert-text"><?= esc($alertMessage['content']); ?></div>
            <div class="alert-close">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true"><i class="ki ki-close"></i></span>
                </button>
            </div>
        </div>
        <!--end::ProcessingAlerts-->

        <?php

        } // End if

        ?>
        <!--begin::Details-->
        <div class="d-flex mb-9">
            <!--begin: Pic-->
            <div class="flex-shrink-0 mr-7 mt-lg-0 mt-3">
                <div class="symbol symbol-50 symbol-lg-120 symbol-light-primary">

                	<?php

                	// Process only if the user has a valid photo
                	if(! empty($userPhoto))
                	{

                	?>
                    <img src="<?= $userPhoto; ?>" alt="profile photo <?= $userFirstName . ' ' . $userLastName; ?>" />
                    <?php

					} // End if
					else
					{

                    ?>
                    <span class="symbol-label font-size-h1 font-weight-boldest"><?= substr(ucfirst(esc($userFirstName)), 0, 1) . substr(ucfirst(esc($userLastName)), 0, 1); ?></span>
                    <?php

                	} // End else

                	?>
                </div>

                <div class="symbol symbol-50 symbol-lg-120 symbol-primary d-none">
                    <span class="font-size-h3 symbol-label font-weight-boldest"><?= substr(ucfirst(esc($userFirstName)), 0, 1) . substr(ucfirst(esc($userLastName)), 0, 1); ?></span>
                </div>
            </div>
            <!--end::Pic-->

            <!--begin::Info-->
            <div class="flex-grow-1">
                <!--begin::Title-->
                <div class="d-flex justify-content-between flex-wrap mt-1">
                    <div class="d-flex mr-3">
                        <a href="javascript:;" class="text-dark-75 text-hover-primary font-size-h5 font-weight-bold mr-3"><?= ucfirst($userFirstName) . ' ' . mb_strtoupper($userLastName); ?></a>
                    </div>
                </div>
                <!--end::Title-->

                <!--begin::Content-->
                <div class="d-flex flex-wrap justify-content-between mt-1">
                    <div class="d-flex flex-column flex-grow-1 pr-8">
                        <div class="d-flex flex-wrap mb-4">
                            <a href="#" class="text-dark-50 text-hover-primary font-weight-bold mr-lg-8 mr-5 mb-lg-0 mb-2"><i class="flaticon2-new-email mr-2 font-size-lg"></i><?= mb_strtolower($userEmail); ?></a>
                            <a href="#" class="text-dark-50 text-hover-primary font-weight-bold mr-lg-8 mr-5 mb-lg-0 mb-2"><i class="flaticon2-calendar-3 mr-2 font-size-lg"></i><?= trim($userPhone); ?> </a>
                            <!-- Role -->
                            <?php
                            // Display only if there is any role available
                            if(! empty($userRole)) {
                            ?>
                            <a href="#" class="text-dark-50 text-hover-primary font-weight-bold"><i class="flaticon2-placeholder mr-2 font-size-lg"></i><?= mb_strtoupper($userRole); ?></a>
                            <?php
                            } // End if
                            ?>
                        </div>
                    </div>
                </div>
                <!--end::Content-->
            </div>
            <!--end::Info-->
        </div>
        <!--end::Details-->

        <div class="separator separator-solid"></div>

        <div class="row mt-2">
        	<div class="col-md-12">
        		<ul class="nav nav-tabs nav-tabs-line nav-tabs-line-3x">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="tab" href="#<?= $tab['details']; ?>">
                            <span class="nav-icon">
                                <span class="svg-icon svg-icon-sm">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <polygon points="0 0 24 0 24 24 0 24"/>
                                            <path d="M5.85714286,2 L13.7364114,2 C14.0910962,2 14.4343066,2.12568431 14.7051108,2.35473959 L19.4686994,6.3839416 C19.8056532,6.66894833 20,7.08787823 20,7.52920201 L20,20.0833333 C20,21.8738751 19.9795521,22 18.1428571,22 L5.85714286,22 C4.02044787,22 4,21.8738751 4,20.0833333 L4,3.91666667 C4,2.12612489 4.02044787,2 5.85714286,2 Z" fill="#000000" fill-rule="nonzero" opacity="0.3"/>
                                            <path d="M14.5,12 C15.0522847,12 15.5,12.4477153 15.5,13 L15.5,16 C15.5,16.5522847 15.0522847,17 14.5,17 L9.5,17 C8.94771525,17 8.5,16.5522847 8.5,16 L8.5,13 C8.5,12.4477153 8.94771525,12 9.5,12 L9.5,11.5 C9.5,10.1192881 10.6192881,9 12,9 C13.3807119,9 14.5,10.1192881 14.5,11.5 L14.5,12 Z M12,10 C11.1715729,10 10.5,10.6715729 10.5,11.5 L10.5,12 L13.5,12 L13.5,11.5 C13.5,10.6715729 12.8284271,10 12,10 Z" fill="#000000"/>
                                        </g>
                                    </svg>
                                </span>
                                <!-- <i class="flaticon-cogwheel-1"></i> -->
                            </span>
                            <span class="nav-text"> 
                                <?= ucfirst(lang('Profile.tab.details.title')); ?>
                            </span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="tab" href="#<?= $tab['password']; ?>">
                        	<span class="nav-icon">
                        		<span class="svg-icon svg-icon-sm">
		                        	<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
									    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
									        <rect x="0" y="0" width="24" height="24"/>
									        <path d="M7.38979581,2.8349582 C8.65216735,2.29743306 10.0413491,2 11.5,2 C17.2989899,2 22,6.70101013 22,12.5 C22,18.2989899 17.2989899,23 11.5,23 C5.70101013,23 1,18.2989899 1,12.5 C1,11.5151324 1.13559454,10.5619345 1.38913364,9.65805651 L3.31481075,10.1982117 C3.10672013,10.940064 3,11.7119264 3,12.5 C3,17.1944204 6.80557963,21 11.5,21 C16.1944204,21 20,17.1944204 20,12.5 C20,7.80557963 16.1944204,4 11.5,4 C10.54876,4 9.62236069,4.15592757 8.74872191,4.45446326 L9.93948308,5.87355717 C10.0088058,5.95617272 10.0495583,6.05898805 10.05566,6.16666224 C10.0712834,6.4423623 9.86044965,6.67852665 9.5847496,6.69415008 L4.71777931,6.96995273 C4.66931162,6.97269931 4.62070229,6.96837279 4.57348157,6.95710938 C4.30487471,6.89303938 4.13906482,6.62335149 4.20313482,6.35474463 L5.33163823,1.62361064 C5.35654118,1.51920756 5.41437908,1.4255891 5.49660017,1.35659741 C5.7081375,1.17909652 6.0235153,1.2066885 6.2010162,1.41822583 L7.38979581,2.8349582 Z" fill="#000000" opacity="0.3"/>
									        <path d="M14.5,11 C15.0522847,11 15.5,11.4477153 15.5,12 L15.5,15 C15.5,15.5522847 15.0522847,16 14.5,16 L9.5,16 C8.94771525,16 8.5,15.5522847 8.5,15 L8.5,12 C8.5,11.4477153 8.94771525,11 9.5,11 L9.5,10.5 C9.5,9.11928813 10.6192881,8 12,8 C13.3807119,8 14.5,9.11928813 14.5,10.5 L14.5,11 Z M12,9 C11.1715729,9 10.5,9.67157288 10.5,10.5 L10.5,11 L13.5,11 L13.5,10.5 C13.5,9.67157288 12.8284271,9 12,9 Z" fill="#000000"/>
									    </g>
									</svg>
								</span>
								<!-- <i class="flaticon-cogwheel-1"></i> -->
							</span>
                        	<span class="nav-text">
                        		<?= ucfirst(lang('Profile.tab.password.title')); ?>
                        	</span>
                        </a>
                    </li>
                </ul>
        	</div>
        </div>
    </div>
</div>
<!--end::Card-->


<!--begin::Tabs Content-->
<div class="tab-content">
    <div class="tab-pane fade show active" id="<?= $tab['details']; ?>" role="tabpanel" aria-labelledby="<?= $tab['details']; ?>">
        <?= $partials['infos']; ?>
    </div>
    <div class="tab-pane fade" id="<?= $tab['password']; ?>" role="tabpanel" aria-labelledby="<?= $tab['password']; ?>">
        <?= $partials['password']; ?>
    </div>
</div>
<!--end::Tabs Content-->


<script>
    LANG_FILE['page'] = <?= json_encode($pageDetails['localization']); ?>;
</script>