<?php
namespace App\Models;

// Call Model Namespace
use CodeIgniter\Model;

// Load required models
use App\Models\PacksModel; // packs
use App\Models\BucketsModel; // packs buckets

// Begin UsersModel class
class UsersModel extends Model
{

    // Defined all the required data
    protected $table = 'user';
    protected $primaryKey = 'id';

    protected $returnType     = 'array';
    protected $useSoftDeletes = true;
    
    // protected $allowedFields = ['user.id', 'user.role_id', 'user.user_id', 'user.first_name', 'user.last_name', 'user.phone', 'user.email', 'user.pwd', 'user.random_salt', 'user.photo', 'user.token', 'user.active', 'user.deleted', 'user.created_by', 'user.deleted_by', 'user.created_at', 'user.deleted_at', 'user.updated_at, role.name as roleName'];
    protected $allowedFields = ['id', 'role_id', 'user_id', 'first_name', 'last_name', 'api_key', 'phone', 'email', 'pwd', 'random_salt', 'photo', 'company', 'company_website', 'max_sender_ids', 'type', 'activation_code', 'recovery_code', 'recovery_date', 'token', 'active', 'deleted', 'created_by', 'deleted_by', 'created_at', 'deleted_at', 'updated_at'];

    // Set the allowed field to use as login credentials
    protected $allowedLogin = ['email', 'phone'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;


    

    //-----------------------------------------------------------------
    // LIST ALL THE DATA AVAILABLES OR RETURN A SPECIFIED DATA DETAILS
    //-----------------------------------------------------------------
        public function list($id = 0)
        {

            // Check wether an id has been specified or not
            if ($id === 0)
            {

                // Returns all the rows availables
                return $this->findAll();

            } // End if

            // Return the row details
            return $this->asArray()
                        // ->join('role', 'role.id = user.role_id')
                        ->where(['user.id' => $id])
                        ->first(); // Return the first item

        } // End function
    //-----------------------------------------------------------------

    //-------------------------------
    // COUNT ALL THE ROWS AVAILABLES
    //-------------------------------
        public function countTotal($keyword = '', $allFields = false)
        {

            // Process only if the keyword is not empty
            // Search through all the availables fields if required
            if($allFields && ! empty($keyword))
            {

                // Get the search array
                $searchArray = $this->_searchArray($keyword);

                // Return the rows that match any column
                return $this->orLike($searchArray)
                            ->countAllResults();

            } // End if

            // Return the rows that match even if the keyword is empty
            return $this->like($this->searchFields[0], $keyword)
                        ->countAllResults();

        } // End function
    //-------------------------------

    //------------------------------
    // CREATE A NEW ROW IN DATABASE
    //------------------------------
        /**
         * A method that will attempt to
         * add a new line to the `user` table
         * and return a boolean on the process result
         *
         * @param array|object $data
         *
         * @return boolean
         */
        public function createRow($data = [])
        {

            // Process only if the sent data is not empty
            if(! empty($data))
            {

                // Get the role_id
                $roleId = (! empty($data['role']) && intval($data['role']) > 0) ? intval($data['role']) : null;

                // Get the required informations for password encryption
                $passwd = $data['pwd'];
                $randomSalt = $this->_randomSalt();
                $encryptedPasswd = $this->hashPasswd($passwd, $randomSalt);

                return $this->save([
                    'role_id'           => $roleId,
                    'first_name'        => $data['firstName'],
                    'last_name'         => $data['lastName'],
                    'phone'             => $data['phone'],
                    'email'             => $data['email'],
                    'random_salt'       => $randomSalt,
                    'pwd'               => $encryptedPasswd,
                    'type'              => mb_strtoupper($data['type']),
                    'activation_code'   => $data['code'],
                    'company'           => $data['company'],
                    'company_website'   => $data['companyWebsite'],
                    // 'active'        => intval($data['active'])
                ]);

            } // End if

            // Return the function response
            return false;

        } // End function
    //------------------------------

    //------------------------------------------
    // CHECK WETHER A ROW IS A DUPLICATE OR NOT
    //------------------------------------------
        public function isDuplicate($where = [], $orWhere = [])
        {

            // Set the default answer to return
            $isDuplicate = true;

            // Process only if there is a orWhere available
            if(! empty($orWhere))
            {
                
                $this->groupStart()
                        ->orWhere($orWhere)
                    ->groupEnd();

            } // End if

            // Try to get the row
            $row = $this->where($where)
                        ->get()
                        ->getResultArray();

            // Check the row
            if( empty($row))
            {

                // Set the row as not duplicate
                $isDuplicate = false;

            } // End if

            // Return the answer
            return $isDuplicate;

        } // End function
    //------------------------------------------

    //-----------------------------------------------------
    // ACCESS AND RETURN A USER DATA USING HIS CREDENTIALS
    //-----------------------------------------------------
        public function signIn($credentials = [])
        {

            // Set the default data to return
            $data = [];
            $status = 'denied';
            // $message = 'Can\'t connect the user';
            // $message = 'No user found using this credentials';
            $message = 'Incorrect login or password provided';

            // Process only if the sent credentials is not empty
            if(! empty($credentials))
            {

                // Get the user credentials
                // $login = $credentials['login'];
                // $passwd = $credentials['passwd'];
                $login = (is_array($credentials) && ! empty($credentials['login'])) ? $credentials['login'] : $credentials->{'login'};
                $passwd = (is_array($credentials) && ! empty($credentials['passwd'])) ? $credentials['passwd'] : $credentials->{'passwd'};

                // Test
                // ...
                // var_dump($login);
                // var_dump($this->_isUserLogin($login));
                // exit;

                // Check wether the specified login match any user login or not
                if($this->_isUserLogin($login))
                {

                    // Get the user random_salt value
                    $randomSalt = $this->_getRandomSaltByLogin($login);

                    // Get encrypted the sent password using the get user random_salt
                    $password = $this->hashPasswd($passwd, $randomSalt['random_salt']);

                    // Try to get the user that corresponds to the specified password
                    $userInfos = $this->_getUserInfoByPassword($password, $login); // The encrypted one

                    // Test
                    // ...
                    // var_dump($randomSalt);
                    // var_dump($password);
                    // var_dump($userInfos);
                    // exit;

                    // Check wether the encrypted password match the user one or not
                    if(! empty($userInfos))
                    {

                        // Set the data value to return
                        $data = $userInfos;

                        // Set the message to return
                        // $message = 'The user account has already expired';
                        // $message = 'The user account is no longer active';

                        // Get the activation status
                        $activeAccount = (! empty($userInfos['active']) && intval($userInfos['active']) === 1) ? true : false;

                        // Check wether the user account is active or not
                        if(! $activeAccount)
                        {

                            // Return the user activation informations
                            return [
                                'status'    => 'denied',
                                'message'   => 'This user account must be activated',
                                'data'      => [
                                    'email' => $userInfos['email']
                                ],
                            ];

                        } // End if

                        // Check wether the user account is active or not
                        // if(! empty($userInfos['active'])
                        //     && intval($userInfos['active']) === 1
                        // )
                        // {

                        // Set the new authentification status
                        $status = 'granted';

                        // Set the message to return
                        $message = 'A user account successfully matches the sent credentials';

                            // Update the user token
                            

                        // } // End if
                        // else
                        // {

                            // Set the message to return
                            //$message = 'No user found using this credentials';

                        // } // End else

                    } // End if

                } // End if
                // else
                // {

                    // Set the message to return
                    // $message = 'No user found using this credentials';
                    // $message = 'Incorrect login or password provided';

                // } // End else

            } // End if

            // Set the response value
            $response = [
                'status'    => $status,
                'data'      => $data,
                'message'   => $message
            ];

            // Return the function response
            return $response;

        } // End function
    //-----------------------------------------------------

    //------------------------------------------------
    // ACTIVATE THE USER ACCOUNT AND CONNECT THE USER
    //------------------------------------------------
        public function activateAccount($data = [])
        {

            // Set the default data to return
            $responseData = [];
            $status = 'denied';
            $message = 'Invalid or wrong activation code provided';

            // Test
            // ...
            // var_dump($data);
            // var_dump($this->_generateAPIKey($data['code']));
            // exit;

            // Process only if the sent data is not empty
            if(! empty($data))
            {

                // Get the user data
                $email = (is_array($data) && ! empty($data['email'])) ? $data['email'] : $data->{'email'};
                $code = (is_array($data) && ! empty($data['code'])) ? $data['code'] : $data->{'code'};

                // Check wether the specified email match any user login or not
                if($this->_isUserNotActivated($email))
                {

                    // Get activated the user account
                    $activatedAccount = $this->_activateAccount($data);

                    // Check wether the encrypted password match the user one or not
                    if(! empty($activatedAccount))
                    {

                        // Return the user activation informations
                        $status = 'granted';
                        $message = 'User account successfully activated';
                        $responseData = $activatedAccount;

                    } // End if

                } // End if

            } // End if

            // Set the response value
            $response = [
                'status'    => $status,
                'data'      => $responseData,
                'message'   => $message
            ];

            // Return the function response
            return $response;

        } // End function
    //------------------------------------------------

    //-------------------------------------------
    // GET A USER INFORMATIONS USING HIS API KEY
    //-------------------------------------------
        public function getUserInfoByAPIKey($apiKey = '')
        {

            // Process only if the encrypted password is not empty
            if(! empty($apiKey)
            )
            {

                // Return the function response
                return $this->select('user.id, user.api_key, user.first_name, user.last_name, user.phone, user.photo, user.company, user.max_sender_ids, user.email, user.active, role.name AS roleName')
                            ->join('role', 'role.id = user.role_id', 'left') // Role_id can be null
                            ->asArray()
                            ->where([
                                'user.api_key'   => $apiKey,
                                'user.active'    => 1,
                            ])
                            ->first();

                // Return the function response

            } // End if

            // Return the function response
            return null;

        } // End function
    //-------------------------------------------




    //--------------------------------------------
    // GET A USER INFORMATIONS USING HIS PASSWORD
    //--------------------------------------------
        public function _getUserInfoByPassword($password = '', $login = '')
        {

            // Process only if the encrypted password is not empty
            if(! empty($password)
                && ! empty($login)
            )
            {

                // Get the login array to look for
                $loginArray = $this->_searchArray($login, $this->allowedLogin);

                // Return the function response
                return $this->select('user.id, user.api_key, user.first_name, user.last_name, user.phone, user.photo, user.company, user.max_sender_ids, user.email, user.active, role.name AS roleName')
                // return $this->select('id, api_key, first_name, last_name, phone, photo, email, active')
                            ->join('role', 'role.id = user.role_id', 'left') // Role_id can be null
                            ->asArray()
                            ->where('pwd', $password)
                            ->groupStart()
                                ->orWhere($loginArray)
                            ->groupEnd()
                            // ->where('deleted', 0)
                            ->first();

                // Return the function response

            } // End if

            // Return the function response
            return null;

        } // End function
    //--------------------------------------------

    //---------------------------------
    // GET A USER PROFILE INFORMATIONS
    //---------------------------------
        /**
         * Return all the user profil informations
         * Using the user row ID to get data
         *
         * @param UNSIGNED int(10) $userID
         *
         * @return array $data
         */
        public function _getUserProfile($userID = 0)
        {

            // Process only if the encrypted password is not empty
            if(! empty($userID)
                && intval($userID) > 0
            )
            {

                // Return the function response
                return $this->select('user.id, user.api_key, user.first_name, user.last_name, user.phone, user.photo, user.company, user.max_sender_ids, user.email, user.active, role.name AS roleName')
                            ->join('role', 'role.id = user.role_id', 'left') // Role_id can be null
                            ->asArray()
                            ->where('user.id', $userID)
                            ->first();

            } // End if

            // Return the function response
            return null;

        } // End function
    //---------------------------------

    //----------------------------------------------
    // GET A USER RANDOM_SALT VALUE USING HIS LOGIN
    //----------------------------------------------
        public function _getRandomSaltByLogin($login = '')
        {

            // Process only if the login is not empty
            if(! empty($login))
            {

                // Get the login array to look for
                $loginArray = $this->_searchArray($login, $this->allowedLogin);

                // Process only if there is any data to look for
                if(! empty($loginArray))
                {

                    // Return the function response
                    return $this->select('random_salt')
                                ->asArray()
                                ->orWhere($loginArray)
                                ->first();

                } // End if

            } // End if

            // Return the function response
            return false;

        } // End function
    //----------------------------------------------

    //---------------------------------------------------------------
    // CHECK IF A SPECIFIED LOGIN MATCH ANY USER LOGIN FROM DATABASE
    //---------------------------------------------------------------
        public function _isUserLogin($login = '')
        {

            // Process only if the login is not empty
            if(! empty($login))
            {

                // Get the login array to look for
                $loginArray = $this->_searchArray($login, $this->allowedLogin);

                // Process only if there is any data to look for
                if(! empty($loginArray))
                {

                    // Get the found user
                    $userId = $this->select('id')
                                ->asArray()
                                ->orWhere($loginArray)
                                ->first();

                    // Return the function response
                    return (! empty($userId)) ? true : false;

                } // End if

            } // End if

            // Return the function response
            return false;

        } // End function
    //---------------------------------------------------------------

    //------------------------------------------------------------------
    // CHECK IF A PENDING RECOVERY REQUEST IS OPEN USING SPECIFIED DATA
    //------------------------------------------------------------------
        public function _isPendingRecoveryRequest($data = [])
        {

            // Get the required data
            $email = (! empty($data['email'])) ? $data['email'] : '';
            $code = (! empty($data['recoveryCode'])) ? $data['recoveryCode'] : '';

            // Process only if the login is not empty
            if(! empty($email)
                && ! empty($code)
            )
            {

                // Get the found user
                $userId = $this->select('id')
                            ->asArray()
                            ->where([
                                'email'         => $email,
                                'recovery_code' => $code,
                                // 'active'        => 1, // Not necessary
                            ])
                            ->first();

                // Return the function response
                return (! empty($userId)) ? true : false;

            } // End if

            // Return the function response
            return false;

        } // End function
    //------------------------------------------------------------------

    //------------------------------------------------------------
    // CHECK IF A SPECIFIED EMAIL MATCH ANY INACTIVE USER ACCOUNT
    //------------------------------------------------------------
        public function _isUserNotActivated($email = '')
        {

            // Process only if the email is not empty
            if(! empty($email))
            {

                // Get the found user
                $userId = $this->select('id')
                            ->asArray()
                            ->where([
                                'api_key'   => null,
                                'email'     => $email,
                                'active'    => 0,
                            ])
                            ->first();

                // Return the function response
                return (! empty($userId)) ? true : false;

            } // End if

            // Return the function response
            return false;

        } // End function
    //------------------------------------------------------------

    //----------------------------------------------------------
    // ACTIVATE A USER ACCOUNT AND RETURN RELATIVE INFORMATIONS
    //----------------------------------------------------------
        public function _activateAccount($data = [])
        {

            // Process only if the encrypted password is not empty
            if(
                ! empty($data)
                && ! empty($data['email'])
                && ! empty($data['code'])
            )
            {

                // Update the user account
                $apiKey = $this->_generateAPIKey($data['code']);
                $this->where('email', $data['email']);
                $this->set([
                    'api_key'           => $apiKey,
                    'activation_code'   => $data['code'],
                    'max_sender_ids'    => DEFAULT_MAX_SENDER_IDS,
                    'active'            => 1,
                ]);
                $this->update();

                // Set the user welcome bucket
                $this->_setWelcomeBonusBucket($data['email']);

                // Return the function response
                return $this->select('user.id, user.api_key, user.first_name, user.last_name, user.phone, user.photo, user.company, user.email, user.active, role.name AS roleName')
                            ->join('role', 'role.id = user.role_id', 'left') // Role_id can be null
                            ->asArray()
                            ->where([
                                'email'             => $data['email'],
                                'activation_code'   => $data['code'],
                            ])
                            ->first();

                // Return the function response

            } // End if

            // Return the function response
            return null;

        } // End function
    //----------------------------------------------------------

    //---------------------------------------------------------
    // RETURN AN ARRAY OF COLUMN WHERE TO LOOK FOR THE KEYWORD
    //---------------------------------------------------------
        public function _searchArray($keyword = '', $searchFields = [])
        {

            // Set the default data to return
            $data = [];

            // Get the array to retrieve
            $searchFields = (! empty($searchFields)) ? $searchFields : $this->searchFields;

            // Process only if a valid keyword has been provided
            // if(! empty($keyword)):
            // if(! empty($keyword)){

                // Loop through all the fields then add the keyword as value
                foreach($searchFields as $searchField):
                // foreach($searchFields as $searchField){
                    
                    // Set a new array item
                    $data["$searchField"] = $keyword;

                // } // End loop
                endforeach; // End loop

            // } // End if
            // endif; // End if

            // Return data as function response
            return $data;


        } // End function
    //---------------------------------------------------------

    //-------------------------
    // GENERATE A USER API KEY
    //-------------------------
        public function _generateAPIKey($keyword = '')
        {

            // Get all the requires informations
            $charsToRemove = ['.', '?', '/', '\\', '$'];
            $randomSalt = $this->_randomSalt();
            $encryptedKey = $this->hashPasswd($keyword, $randomSalt);

            // Return the API Key
            return str_replace($charsToRemove, '', $encryptedKey);

        } // End function
    //-------------------------

    //----------------------------
    // GENERATE A RANDOM SALT KEY
    //----------------------------
        public function _randomSalt()
        {

            // Return the key
            return md5(mt_rand());

        } // End function
    //----------------------------

    //-----------------------------------------
    // HASH A PASSWORD USING A RANDOM SALT KEY
    //-----------------------------------------
        public function hashPasswd($passwd, $randomSalt)
        {

            /**
             * bcrypt is the preferred hashing for passwords, but
             * is only available for PHP 5.3+. Even in a PHP 5.3+ 
             * environment, we have the option to use PBKDF2; just 
             * set the PHP52_COMPATIBLE_PASSWORDS constant located 
             * in config/constants.php to 1.
             */
            // if( CRYPT_BLOWFISH == 1 && PHP52_COMPATIBLE_PASSWORDS === 0 )
            // if(CRYPT_BLOWFISH == 1)
            // {

                // Load the Encryption Library
                $encrypter = \Config\Services::encrypter();

                // Return the encrypted password
                return crypt($passwd . $encrypter->key, '$2a$09$' . $randomSalt . '$');
                // return crypt($passwd . $encrypter->key, $randomSalt);

            // } // End if

            // Fallback to PBKDF2 if bcrypt not available
            // $this->load->helper('pbkdf2'); // constant file
            // helper('pbkdf2'); // constant file

            /**
             * Key length (param #5) set at 30 so that pbkdf2() 
             * returns a string which has a length that matches 
             * the length of the `user_pass` field (60 chars).
             */
            // return pbkdf2::encrypt('sha256', $passwd . $encrypter->key, $randomSalt, 4096, 30, FALSE);

        } // End function
    //-----------------------------------------

    //-------------------------------------------------
    // SET THE WELCOME BONUS PACK FOR A SPECIFIED USER
    //-------------------------------------------------
        public function _setWelcomeBonusBucket($email = '')
        {

            // Process only if the specified email is not empty
            if(! empty($email))
            {

                // Get the specified user ID
                $userID = $this->select('id')
                            ->asArray()
                            ->where([
                                'email'    => $email
                            ])
                            ->first();

                // Load the Packs model
                $packsModel = new PacksModel();

                // Get the welcome pack ID
                $packID = $packsModel->select('id')
                                        ->asArray()
                                        ->orWhere([
                                            'name'  => 'bonus',
                                            'name ' => 'Bonus',
                                            ' name' => 'BONUS',
                                        ])
                                        ->first();

                // Process only if all the required data are available
                if(
                    ! empty($userID)
                    && ! empty($packID)
                )
                {

                    // Load the Buckets model
                    $bucketsModel = new BucketsModel();

                    // Create the user bucket
                    $bucketsModel->save([
                        'pack_id'       => $packID['id'],
                        'sms'           => 5,
                        'active'        => 1,
                        'created_by'    => $userID['id'],
                    ]);

                } // End if

            } // End if

        } // End function
    //-------------------------------------------------

} // End UsersModel class