"use strict";

// Class definition
var KTWizard2 = function () {
	// Base elements
	var _wizardEl;
	var _formEl;
	var _wizard;
	var _validations = [];

	// Set the form components informations
	var dtID = 'reloadingDatatable';
	var formModalID = 'reloadingFormModal';
	var paymentFormID = 'cinetPayPaymentForm';
	var formWizardID = 'reloadingWizard';
	var formID = 'reloadingForm';
	var formComponents = {
		packsRadio: 'rd-pack',
		touchSpin: 'volumeTouchSpin',
		wizardSubmit: 'submit-wizard',
	};
	var orderDetails = {
		volume: {
			title: 'span-title-order-volume',
			li: 'span-li-order-volume',
		},
		amount: 'span-li-order-amount',
		formule: {
			name: "span-li-formule-name",
			cost: "span-li-formule-cost",
		},
	};
	var cinetPayLinks = {
		url: 'https://secure.cinetpay.com',
		notify: BASE_URL + '/home/cinetPayNotifyUrl',
		return: BASE_URL + '/home/cinetPayReturnUrl',
		cancel: BASE_URL + '/home/cinetPayCancelUrl',
	};
    var remoteAJAXFunctions = {
        touchSpinData: 'RemoteData/getPackDetailsJSON',
        setForm: 'customers/setReloading',
    };
    var selectedPackRadio;

	// Private functions
	var initWizard = function () {
		// Initialize form wizard
		_wizard = new KTWizard(_wizardEl, {
			startStep: 1, // initial active step number
			clickableSteps: false // to make steps clickable this set value true and add data-wizard-clickable="true" in HTML for class="wizard" element
		});

		// Validation before going to next page
		_wizard.on('beforeNext', function (wizard) {
			// Don't go to the next step yet
			_wizard.stop();

			// Validate form
			var validator = _validations[wizard.getStep() - 1]; // get validator for current step
			validator.validate().then(function (status) {
				if (status == 'Valid') {
					_wizard.goNext();
					KTUtil.scrollTop();
				} else {
					Swal.fire({
						text: "Sorry, looks like there are some errors detected, please try again.",
						icon: "error",
						buttonsStyling: false,
						confirmButtonText: "Ok, got it!",
						customClass: {
							confirmButton: "btn font-weight-bold btn-light"
						}
					}).then(function () {
						KTUtil.scrollTop();
					});
				}
			});

			/**
			 * UPDATE THE ORDER DETAILS
			 */
			
			//Test
			// ...
			// console.log($('input[type=radio][name=' + formComponents.packsRadio + ']').val());

			$.ajax({

                // AJAX Call options
                url: ADMIN_BASE_URL + '/' + remoteAJAXFunctions.touchSpinData + '/' + $('input[type=radio][name=' + formComponents.packsRadio + ']').val(),
                type: "POST",

                // On 'Success' Event
                success: function(data) {

                    // Process only if any data has been loaded
                    if(data) {

                    	// Test
                    	// ...
                    	// console.log(data);

                    	// Get the serverResponse data
                    	var serverResponse = JSON.parse(data);

                    	// Get the volume value
                    	var volume = $('#' + formComponents.touchSpin).val();
                    	var amount = volume * serverResponse.localCost;

                    	// Update the data
                    	$('#' + orderDetails.volume.title).text(volume);
                    	$('#' + orderDetails.volume.li).text(volume);
                    	$('#' + orderDetails.formule.name).text(serverResponse.name);
                    	$('#' + orderDetails.formule.cost).text(serverResponse.localCost);
                    	$('#' + orderDetails.amount).text(amount);

                    	// Test
                    	// ...
                    	// console.log($('#' + formComponents.touchSpin).val());
                    	// console.log($('#' + formComponents.touchSpin).val() * serverResponse.localCost);
                    	// console.log($('#' + orderDetails.volume.title).text());
                    	// console.log($('#' + orderDetails.volume.li).text());
                    	// console.log($('#' + orderDetails.formule.name).text());
                    	// console.log($('#' + orderDetails.formule.cost).text());
                    	// console.log($('#' + orderDetails.amount).text());

                    } // End if

                }, // End success event

            });
		});

		// Change event
		_wizard.on('change', function (wizard) {
			KTUtil.scrollTop();
		});
	}

	var initValidation = function () {
		// Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
		// Step 1
		_validations.push(FormValidation.formValidation(
			_formEl,
			{
				fields: {
					fname: {
						validators: {
							notEmpty: {
								message: 'First name is required'
							}
						}
					},
					lname: {
						validators: {
							notEmpty: {
								message: 'Last Name is required'
							}
						}
					},
					phone: {
						validators: {
							notEmpty: {
								message: 'Phone is required'
							}
						}
					},
					email: {
						validators: {
							notEmpty: {
								message: 'Email is required'
							},
							emailAddress: {
								message: 'The value is not a valid email address'
							}
						}
					}
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		));

		// Step 2
		_validations.push(FormValidation.formValidation(
			_formEl,
			{
				fields: {
					address1: {
						validators: {
							notEmpty: {
								message: 'Address is required'
							}
						}
					},
					postcode: {
						validators: {
							notEmpty: {
								message: 'Postcode is required'
							}
						}
					},
					city: {
						validators: {
							notEmpty: {
								message: 'City is required'
							}
						}
					},
					state: {
						validators: {
							notEmpty: {
								message: 'State is required'
							}
						}
					},
					country: {
						validators: {
							notEmpty: {
								message: 'Country is required'
							}
						}
					}
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		));

		// Step 3
		_validations.push(FormValidation.formValidation(
			_formEl,
			{
				fields: {
					delivery: {
						validators: {
							notEmpty: {
								message: 'Delivery type is required'
							}
						}
					},
					packaging: {
						validators: {
							notEmpty: {
								message: 'Packaging type is required'
							}
						}
					},
					preferreddelivery: {
						validators: {
							notEmpty: {
								message: 'Preferred delivery window is required'
							}
						}
					}
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		));

		// Step 4
		_validations.push(FormValidation.formValidation(
			_formEl,
			{
				fields: {
					locaddress1: {
						validators: {
							notEmpty: {
								message: 'Address is required'
							}
						}
					},
					locpostcode: {
						validators: {
							notEmpty: {
								message: 'Postcode is required'
							}
						}
					},
					loccity: {
						validators: {
							notEmpty: {
								message: 'City is required'
							}
						}
					},
					locstate: {
						validators: {
							notEmpty: {
								message: 'State is required'
							}
						}
					},
					loccountry: {
						validators: {
							notEmpty: {
								message: 'Country is required'
							}
						}
					}
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		));

		// Step 5
		_validations.push(FormValidation.formValidation(
			_formEl,
			{
				fields: {
					ccname: {
						validators: {
							notEmpty: {
								message: 'Credit card name is required'
							}
						}
					},
					ccnumber: {
						validators: {
							notEmpty: {
								message: 'Credit card number is required'
							},
							creditCard: {
								message: 'The credit card number is not valid'
							}
						}
					},
					ccmonth: {
						validators: {
							notEmpty: {
								message: 'Credit card month is required'
							}
						}
					},
					ccyear: {
						validators: {
							notEmpty: {
								message: 'Credit card year is required'
							}
						}
					},
					cccvv: {
						validators: {
							notEmpty: {
								message: 'Credit card CVV is required'
							},
							digits: {
								message: 'The CVV value is not valid. Only numbers is allowed'
							}
						}
					}
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		));
	}

	var initComponents = function() {

		// 'use strict';
		// Set the touchspin on pack selection
		$(document).on('change', 'input[type=radio][name=' + formComponents.packsRadio + ']', function () {

			// 'use strict';

			// Test
			// ...
			// console.log(this.value);
			// setTouchSpin(this.value);

			// Set the touchspin data
			setTouchSpin(this.value);

		});

		// Init the touchspin
		$('#' + formID + ' #' + formComponents.touchSpin).TouchSpin({
			buttondown_class: 'btn btn-secondary',
			buttonup_class: 'btn btn-secondary',
		});

		// Set the touchspin default value
		// ...

		// 'use strict';
		function setTouchSpin(pack) {

			// AJAX function to load the form data to display
            $.ajax({

                // AJAX Call options
                url: ADMIN_BASE_URL + '/' + remoteAJAXFunctions.touchSpinData + '/' + pack,
                type: "POST",

                // On 'Success' Event
                success: function(data) {

                    // Process only if any data has been loaded
                    if(data) {

                    	// Test
                    	// ...
                    	// console.log(data);

                    	// Get the serverResponse data
                    	var serverResponse = JSON.parse(data);

                    	// Test
                    	// ...
                    	// console.log(serverResponse);
                    	// console.log(serverResponse.step);
                    	// console.log(serverResponse.max);

                        // Init the touchspin
                        $('#' + formID + ' #' + formComponents.touchSpin).trigger('touchspin.updatesettings', {
                        // $('#' + formID + ' #' + formComponents.touchSpin).TouchSpin({
							// buttondown_class: 'btn btn-secondary',
							// buttonup_class: 'btn btn-secondary',

							initVal: serverResponse.min,
							min: serverResponse.min,
							max: serverResponse.max,
							// step: serverResponse.step ? serverResponse.step : serverResponse.max,
							step: serverResponse.step,
							// boostat: serverResponse.min, // Default 5
							// boostat: 5, // Default 5
							// maxboostedstep: serverResponse.step, // Default 10
							// maxboostedstep: serverResponse.step ? serverResponse.step : serverResponse.max, // Default 10
						});

                    } // End if

                }, // End success event

            });

			// Test
			// ...
			// console.log('Function: ' + pack);

		} // End function

		// ...
		selectedPackRadio = $('input[type=radio][name=' + formComponents.packsRadio + ']:checked').val();
		// selectedPackRadio = $('input[type=radio][name=' + formComponents.packsRadio + ']').val();
		setTouchSpin(selectedPackRadio);



		//******************************
		// SET THE RELOADING USING AJAX
		//******************************
		function setReloading() {

            // Call a block UI
            KTApp.block('#' + formModalID + ' form', {
                overlayColor: '#000000',
                state: 'warning',
                // message: 'Traitement...',
                message: 'Redirection vers la plateforme de paiement en cours, veuillez patienter...',
            });

            // Get all the required data
            var formElement = $('#' + formID),
                formData = new FormData(formElement[0]);

            // AJAX Function to post the form data to database
            $.ajax({

                // AJAX Call options
                url: ADMIN_BASE_URL + '/' + remoteAJAXFunctions.setForm,
                type: 'POST',
                processData: false,
                contentType: false,
                data: formData,

                // On 'Success' Event
                success: function(data) {

                	// Test
                	// ...
                	// console.log(data);

                    // Set the toast options
                    toastr.options = {
                      "closeButton": true,
                      "debug": false,
                      "newestOnTop": true,
                      "progressBar": false,
                      "positionClass": "toast-top-right",
                      "preventDuplicates": false,
                      "onclick": null,
                      "showDuration": "300",
                      "hideDuration": "1000",
                      "timeOut": "7000",
                      "extendedTimeOut": "600",
                      "showEasing": "swing",
                      "hideEasing": "linear",
                      "showMethod": "fadeIn",
                      "hideMethod": "fadeOut"
                    };

                    // Get the data value
                    var serverResponse = JSON.parse(data);

                    // Check the response type
                    if(serverResponse.type === 'success')
                    {

                    	// Test
                    	// ...
                    	console.log(serverResponse.cinetPayData.cpm_amount);
                    	console.log(serverResponse.cinetPayData.cpm_currency);
                    	console.log(serverResponse.cinetPayData.cpm_site_id);
                    	console.log(serverResponse.cinetPayData.cpm_trans_id);
                    	console.log(serverResponse.cinetPayData.cpm_trans_date);
                    	console.log(serverResponse.cinetPayData.cpm_payment_config);
                    	console.log(serverResponse.cinetPayData.cpm_page_action);
                    	console.log(serverResponse.cinetPayData.cpm_version);
                    	console.log(serverResponse.cinetPayData.cpm_language);
                    	// console.log(serverResponse.cinetPayData.cpm_custom);
                    	console.log(serverResponse.cinetPayData.cpm_designation);
                    	console.log(serverResponse.cinetPayData.apikey);
                    	console.log(serverResponse.cinetPayData.signature);
                    	console.log(cinetPayLinks.notify);
                    	console.log(cinetPayLinks.return);
                    	console.log(cinetPayLinks.cancel);

                        // Push the server response as toast
                        toastr.success(serverResponse.message);



                        //********************************
                        // CALL THE CINTEPAY PAYMENT FORM
                        //********************************

                        	// ToastR for redirection wait
                        	toastr.warning('Redirection vers la plateforme de paiement !');
                        	// toastr.info('Redirection vers la plateforme de paiement !');
                        	// toastr.warning('Redirection vers la plateforme de paiement en cours, veuillez patienter !');

                        	// Create the payment form using FormData
				            // var paymentForm = new FormData(); // New empty form

				            // Get all the required data
				            // var formElement = $('#' + paymentFormID),
				            //     paymentForm = new FormData(formElement[0]);
				            var formElement = $('#' + paymentFormID);

				            // Set the form key / value couple data
				            // paymentForm.append('cpm_amount', serverResponse.cinetPayData.cpm_amount);
				            // paymentForm.append('cpm_currency', serverResponse.cinetPayData.cpm_currency);
				            // paymentForm.append('cpm_site_id', serverResponse.cinetPayData.cpm_site_id);
				            // paymentForm.append('cpm_trans_id', serverResponse.cinetPayData.cpm_trans_id);
				            // paymentForm.append('cpm_trans_date', serverResponse.cinetPayData.cpm_trans_date);
				            // paymentForm.append('cpm_payment_config', serverResponse.cinetPayData.cpm_payment_config);
				            // paymentForm.append('cpm_page_action', serverResponse.cinetPayData.cpm_page_action);
				            // paymentForm.append('cpm_version', serverResponse.cinetPayData.cpm_version);
				            // paymentForm.append('cpm_language', serverResponse.cinetPayData.cpm_language);
				            // paymentForm.append('cpm_custom', serverResponse.cinetPayData.cpm_custom);
				            // paymentForm.append('cpm_designation', serverResponse.cinetPayData.cpm_designation);
				            // paymentForm.append('apikey', serverResponse.cinetPayData.apikey);
				            // paymentForm.append('signature', serverResponse.cinetPayData.signature);
				            // paymentForm.append('notify_url', cinetPayLinks.notify);
				            // paymentForm.append('return_url', cinetPayLinks.return);
				            // paymentForm.append('cancel_url', cinetPayLinks.cancel);



				            formElement.append('<input type="hidden" name="cpm_amount" value="' + serverResponse.cinetPayData.cpm_amount + '" />');
				            formElement.append('<input type="hidden" name="cpm_currency" value="' + serverResponse.cinetPayData.cpm_currency + '" />');
				            formElement.append('<input type="hidden" name="cpm_site_id" value="' + serverResponse.cinetPayData.cpm_site_id + '" />');
				            formElement.append('<input type="hidden" name="cpm_trans_id" value="' + serverResponse.cinetPayData.cpm_trans_id + '" />');
				            formElement.append('<input type="hidden" name="cpm_trans_date" value="' + serverResponse.cinetPayData.cpm_trans_date + '" />');
				            formElement.append('<input type="hidden" name="cpm_payment_config" value="' + serverResponse.cinetPayData.cpm_payment_config + '" />');
				            formElement.append('<input type="hidden" name="cpm_page_action" value="' + serverResponse.cinetPayData.cpm_page_action + '" />');
				            formElement.append('<input type="hidden" name="cpm_version" value="' + serverResponse.cinetPayData.cpm_version + '" />');
				            formElement.append('<input type="hidden" name="cpm_language" value="' + serverResponse.cinetPayData.cpm_language + '" />');
				            formElement.append('<input type="hidden" name="cpm_designation" value="' + serverResponse.cinetPayData.cpm_designation + '" />');
				            formElement.append('<input type="hidden" name="apikey" value="' + serverResponse.cinetPayData.apikey + '" />');
				            formElement.append('<input type="hidden" name="signature" value="' + serverResponse.cinetPayData.signature + '" />');
				            formElement.append('<input type="hidden" name="notify_url" value="' + cinetPayLinks.notify + '" />');
				            formElement.append('<input type="hidden" name="return_url" value="' + cinetPayLinks.return + '" />');
				            formElement.append('<input type="hidden" name="cancel_url" value="' + cinetPayLinks.cancel + '" />');

				   //          $.ajax({
							// 	url: "https://secure.cinetpay.com", // Server URL
							// 	type: "POST", // sent method
							// 	data: paymentForm, // Form data to send
							// 	processData: false,  // Tell jQuery to not process the data
							// 	contentType: false   // Tell jQuery to not set ContentType
							// });

							// var request = new XMLHttpRequest();
							// request.withCredentials = true;
							// request.open("POST", cinetPayLinks.url);
							// request.setRequestHeader('Access-Control-Allow-Origin', '*');
							// request.send(paymentForm);

							// Submit the form
							formElement[0].submit();

                        //********************************



	                    // Unblock the content
	                    // KTApp.unblock('#' + formModalID + ' form');

                        // Dismiss the form modal
                        // $('#' + formModalID).modal('hide');

                        // Reload the datatable
                        // $('#' + dtID).KTDatatable('reload');

                    } // End if
                    else if(serverResponse.type === 'warning')
                    {

                        // Push the server response as toast
                        toastr.warning(serverResponse.message);

                    } // End else if
                    else
                    {

                        // Push the server response as toast
                        toastr.error(serverResponse.message);

                    } // End else

                }, // End Success Event
            });

		}
		//******************************

        // Hold then process the form submit event
        $(document).on('submit', '#' + formModalID + ' form', function(e) {

            // Prevent the default form submit behaviour
            e.preventDefault();

            // Call the processing function
            setReloading();

        });

        // Process the form on submit button click
        $(document).on('click', '#' + formComponents.wizardSubmit, function() {

        	// Call the processing function
            setReloading();

        });

	}

	return {
		// public functions
		init: function () {
			_wizardEl = KTUtil.getById(formWizardID);
			_formEl = KTUtil.getById(formID);


			initWizard();
			initValidation();

			initComponents(); // Reloading form components

		}
	};
}();

jQuery(document).ready(function () {
	KTWizard2.init();
});
