"use strict";

// Class Definition
var KTLogin = function() {
    var _login;

    var _showForm = function(form) {
        var cls = 'login-' + form + '-on';
        var form = 'login_' + form + '_form';

        _login.removeClass('login-forgot-on');
        _login.removeClass('login-signin-on');

        _login.addClass(cls);

        KTUtil.animateClass(KTUtil.getById(form), 'animate__animated animate__backInUp');
    }

    var _handleSignInForm = function() {
        var validation;

        // Set all the data
        var loginContainer = 'loginContainer',

        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
        validation = FormValidation.formValidation(
			KTUtil.getById('login_signin_form'),
			{
				fields: {
					'txt-login': {
						validators: {
							notEmpty: {
								message: ucfirst(LANG_FILE.page.signIn.field.login.validation.required)
							}
						}
					},
					'txt-pwd': {
						validators: {
							notEmpty: {
								message: ucfirst(LANG_FILE.page.signIn.field.password.validation.required)
							}
						}
					}
				},
				plugins: {
                    trigger: new FormValidation.plugins.Trigger(),
                    submitButton: new FormValidation.plugins.SubmitButton(),
                    //defaultSubmit: new FormValidation.plugins.DefaultSubmit(), // Uncomment this line to enable normal button submit after form validation
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		);

        $('#login_signin_submit').on('click', function (e) {
            e.preventDefault();

            // Call a block UI
            KTApp.block('#' + loginContainer, {
                overlayColor: '#000000',
                state: 'warning',
                message: ucfirst(LANG_FILE.general.action.processing)
            });

            validation.validate().then(function(status) {
		        if (status == 'Valid') {


                    // Get all the required data
                    var formElement = $('#login_signin_form'),
                        formData = new FormData(formElement[0]);

                    // Try to sign in the user using AJAX
                    $.ajax({

                        // AJAX Call options
                        url: BASE_URL + '/' + LOCALE + '/sign/in',
                        type: 'POST',
                        processData: false,
                        contentType: false,
                        data: formData,

                        // On 'Success' Event
                        success: function(data) {

                            // Set the toast options
                            toastr.options = {
                              "closeButton": true,
                              "debug": false,
                              "newestOnTop": true,
                              "progressBar": false,
                              "positionClass": "toast-top-left",
                              "preventDuplicates": false,
                              "onclick": null,
                              "showDuration": "1500",
                              "hideDuration": "5000",
                              "timeOut": "35000",
                              "extendedTimeOut": "3000",
                              "showEasing": "swing",
                              "hideEasing": "linear",
                              "showMethod": "fadeIn",
                              "hideMethod": "fadeOut"
                            };

                            // Get the data value
                            // var serverResponse = JSON.parse(data);
                            var serverResponse = data;

                            // Check the response type
                            if(serverResponse.code === 'success')
                            {

                                // Push the server response as toast
                                toastr.success(serverResponse.message);

                                // Redirect the user to the dashboard
                                // Or refresh the current page
                                // ...

                                // Redirect the user to his dashboard
                                location.reload(); // Just reload the current location

                            } // End if
                            else if(serverResponse.code === 'warning')
                            {

                                // Push the server response as toast
                                toastr.warning(serverResponse.message);

                            } // End else if
                            else
                            {

                                // Push the server response as toast
                                toastr.error(serverResponse.message);

                            } // End else

                            // Unblock the content
                            KTApp.unblock('#' + loginContainer);

                        }, // End Success Event
                    });

				} else {
					swal.fire({
		                text: ucfirst(LANG_FILE.page.signIn.response.error),
		                icon: "error",
		                buttonsStyling: false,
		                confirmButtonText: ucfirst(LANG_FILE.general.action.gotIt),
                        customClass: {
    						confirmButton: "btn font-weight-bold btn-light-primary"
    					}
		            }).then(function() {

                        // Unblock the content
                        KTApp.unblock('#' + loginContainer);
                        
						KTUtil.scrollTop();
					});

				}
		    });
        });

        // Handle forgot button
        $('#login_forgot').on('click', function (e) {
            e.preventDefault();
            _showForm('forgot');
        });
    }

    var _handleForgotForm = function(e) {
        var validation;

        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
        validation = FormValidation.formValidation(
			KTUtil.getById('login_forgot_form'),
			{
				fields: {
					'txt-mail': {
						validators: {
							notEmpty: {
								message: ucfirst(LANG_FILE.page.profile.field.email.validation.required)
							},
                            emailAddress: {
								message: ucfirst(LANG_FILE.page.profile.field.email.validation.valid)
							}
						}
					}
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		);

        // Handle submit button
        $('#login_forgot_submit').on('click', function (e) {
            e.preventDefault();

            validation.validate().then(function(status) {
		        if (status == 'Valid') {
                    // Submit form
                    KTUtil.scrollTop();
				} else {
					swal.fire({
		                text: ucfirst(LANG_FILE.page.signIn.response.error),
		                icon: "error",
		                buttonsStyling: false,
		                confirmButtonText: ucfirst(LANG_FILE.general.action.gotIt),
                        customClass: {
    						confirmButton: "btn font-weight-bold btn-light-primary"
    					}
		            }).then(function() {
						KTUtil.scrollTop();
					});
				}
		    });
        });

        // Handle cancel button
        $('#login_forgot_cancel').on('click', function (e) {
            e.preventDefault();

            _showForm('signin');
        });
    }

    // Public Functions
    return {
        // public functions
        init: function() {
            _login = $('#auth_login');

            _handleSignInForm(); // Sign In
            _handleForgotForm(); // Forgotten password
        }
    };
}();

// Class Initialization
jQuery(document).ready(function() {
    KTLogin.init();
});
