"use strict";

// Shared Colors Definition
const primary = '#6993FF';
const success = '#1BC5BD';
const info = '#8950FC';
const warning = '#FFA800';
const danger = '#F64E60';

// Class definition
var DashboardScripts = function() {

    // General Controls
    var dateTimePeriod = function() {
        if ($('#kt_dashboard_daterangepicker').length == 0) {
            return;
        }

        var picker = $('#kt_dashboard_daterangepicker');

        // By default the last 30 days
        var start = moment().subtract(29, 'days');
        var end = moment();

        function cb(start, end, label) {
            var title = '';
            var range = '';

            if ((end - start) < 100 || label == 'Today') {
                title = ucfirst(LANG_FILE.dates.period.today) + ':';
                range = start.format('MMM D');
            } else if (label == 'Yesterday') {
                title = ucfirst(LANG_FILE.dates.period.yesterday) + ':';
                range = start.format('MMM D');
            } else {
                range = start.format('MMM D YYYY') + ' - ' + end.format('MMM D YYYY');
            }

            $('#kt_dashboard_daterangepicker_date').html(range);
            $('#kt_dashboard_daterangepicker_title').html(title);

            // Hidden Period Data
            $('#period-start').val(start.format('YYYY-MM-DD'));
            $('#period-end').val(end.format('YYYY-MM-DD'));
        }

        picker.daterangepicker({
            direction: KTUtil.isRTL(),
            startDate: start,
            endDate: end,
            opens: 'left',
            applyClass: 'btn-primary',
            cancelClass: 'btn-light-primary',
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'This Year': [moment().startOf('year'), moment().endOf('year')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            }
        }, cb);

        cb(start, end, '');


        // Set a new daterange on 'Period' label click
        $(document).on('click', '#todayPeriod', function() {

            // Test
            // ...
            // console.log(this);

            // Set the daterange period start and end date
            var start = moment();
            var end = moment();

            // Set the daterange period that corresponds
            $('#kt_dashboard_daterangepicker').data('daterangepicker').setStartDate(start);
            $('#kt_dashboard_daterangepicker').data('daterangepicker').setEndDate(end);

            // Fire the period label change function
            cb(start, end, ucfirst(LANG_FILE.dates.period.today));

        });

        // Set a new daterange on 'Period' label click
        $(document).on('click', '#monthPeriod', function() {

            // Set the daterange period start and end date
            var start = moment().startOf('month');
            var end = moment().endOf('month');

            // Set the daterange period that corresponds
            $('#kt_dashboard_daterangepicker').data('daterangepicker').setStartDate(start);
            $('#kt_dashboard_daterangepicker').data('daterangepicker').setEndDate(end);

            // Fire the period label change function
            cb(start, end, '');

        });

        // Set a new daterange on 'Period' label click
        $(document).on('click', '#yearPeriod', function() {

            // Set the daterange period start and end date
            var start = moment().startOf('year');
            var end = moment().endOf('year');

            // Set the daterange period that corresponds
            $('#kt_dashboard_daterangepicker').data('daterangepicker').setStartDate(start);
            $('#kt_dashboard_daterangepicker').data('daterangepicker').setEndDate(end);

            // Fire the period label change function
            cb(start, end, '');

        });
    }

	return {
		// public functions
		init: function() {

            dateTimePeriod(); // Delivery Stats

		}
	};
}();

jQuery(document).ready(function() {
	DashboardScripts.init();
});
