<?php

// Test
// ...
// var_dump($profile);

// Get all the informations required
$userFirstName = (! empty($profile['firstName'])) ? $profile['firstName'] : '';
$userLastName = (! empty($profile['lastName'])) ? $profile['lastName'] : '';
$userEmail = (! empty($profile['email'])) ? $profile['email'] : '';
$userPhone = (! empty($profile['phone'])) ? $profile['phone'] : '';
$userPhoto = (! empty($profile['photo'])) ? $profile['photo'] : '';

// Set all the CRUD variables
$profileFormID = 'profileForm';
$profileButtons = [
	'submit'	=> 'profileFormSubmit',
];

?>

<form class="form" id="<?= $profileFormID; ?>">

	<?= csrf_field() ?>
	
	<div class="card card-custom card-stretch">
	<!-- <div class="card card-custom card-sticky"> -->
		<!--begin::Header-->
		<div class="card-header py-3">
			<div class="card-title align-items-start flex-column">
				<h3 class="card-label font-weight-bolder text-dark"><?= ucfirst(lang('Profile.tab.details.title')); ?></h3>
	            <span class="text-muted font-weight-bold font-size-sm mt-1"><?= ucfirst(lang('Profile.tab.details.description')); ?></span>
	        </div>
			<div class="card-toolbar">
				<button type="submit" class="btn btn-success mr-2">
	            	<?= ucfirst(lang('General.action.save')); ?>
	            	<span class="svg-icon">
		        		<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
						    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
						        <polygon points="0 0 24 0 24 24 0 24"/>
						        <path d="M9.26193932,16.6476484 C8.90425297,17.0684559 8.27315905,17.1196257 7.85235158,16.7619393 C7.43154411,16.404253 7.38037434,15.773159 7.73806068,15.3523516 L16.2380607,5.35235158 C16.6013618,4.92493855 17.2451015,4.87991302 17.6643638,5.25259068 L22.1643638,9.25259068 C22.5771466,9.6195087 22.6143273,10.2515811 22.2474093,10.6643638 C21.8804913,11.0771466 21.2484189,11.1143273 20.8356362,10.7474093 L17.0997854,7.42665306 L9.26193932,16.6476484 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" transform="translate(14.999995, 11.000002) rotate(-180.000000) translate(-14.999995, -11.000002) "/>
						        <path d="M4.26193932,17.6476484 C3.90425297,18.0684559 3.27315905,18.1196257 2.85235158,17.7619393 C2.43154411,17.404253 2.38037434,16.773159 2.73806068,16.3523516 L11.2380607,6.35235158 C11.6013618,5.92493855 12.2451015,5.87991302 12.6643638,6.25259068 L17.1643638,10.2525907 C17.5771466,10.6195087 17.6143273,11.2515811 17.2474093,11.6643638 C16.8804913,12.0771466 16.2484189,12.1143273 15.8356362,11.7474093 L12.0997854,8.42665306 L4.26193932,17.6476484 Z" fill="#000000" fill-rule="nonzero" transform="translate(9.999995, 12.000002) rotate(-180.000000) translate(-9.999995, -12.000002) "/>
						    </g>
						</svg>
					</span>
	        	</button>
			</div>
		</div>
		<!--end::Header-->

		<!--begin::Form-->
		<!-- <form class="form" id="<?= $profileFormID; ?>"> -->
			<!--begin::Body-->
			<div class="card-body">
	        	<div class="row">
		    		<div class="col-xl-2"></div>
		    		<div class="col-xl-8">
						<div class="row">
							<label class="col-xl-3"></label>
							<div class="col-lg-9 col-xl-9">
								<h5 class="font-weight-bold mb-6"><?= ucfirst(lang('Profile.field.profile.label')); ?></h5>
							</div>
						</div>
						<div class="form-group row">
							<label class="col-xl-3 col-lg-3 col-form-label"><?= ucfirst(lang('Profile.field.avatar.label')); ?></label>
							<div class="col-lg-9 col-xl-9">
								<div class="image-input image-input-outline" id="kt_profile_avatar" style="background-image: url(<?= base_url(); ?>/assets/global/media/users/blank.png)">
			                        <div class="image-input-wrapper" style="background-image: url(<?= $userPhoto; ?>)"></div>

			                        <label class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="change" data-toggle="tooltip" title="" data-original-title="<?= ucfirst(lang('Profile.action.editPhoto')); ?>">
			                            <i class="fa fa-pen icon-sm text-muted"></i>
			                            <input type="file" name="profile_avatar" accept=".png, .jpg, .jpeg"/>
										<input type="hidden" name="profile_avatar_remove"/>
			                        </label>

			                        <span class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="cancel" data-toggle="tooltip" title="<?= ucfirst(lang('Profile.action.cancelPhoto')); ?>">
			                            <i class="ki ki-bold-close icon-xs text-muted"></i>
			                        </span>

			                        <?php

			                        // Hide the cancel button by default
			                        if(! empty($userPhoto))
			                        {

		                        	?>
									<span class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="remove" data-toggle="tooltip" title="<?= ucfirst(lang('Profile.action.removePhoto')); ?>">
			                            <i class="ki ki-bold-close icon-xs text-muted"></i>
			                        </span>
			                        <?php

									} // End if
									
			                        ?>
			                    </div>
			                    <span class="form-text text-muted"><?= ucfirst(lang('Profile.field.avatar.description')); ?>.</span>
							</div>
						</div>
						<div class="form-group row">
							<label class="col-xl-3 col-lg-3 col-form-label"><?= ucfirst(lang('Profile.field.firstName.label')); ?> <span class="text-danger">*</span></label>
							<div class="col-lg-9 col-xl-9">
								<input class="form-control form-control-lg form-control-solid" type="text" value="<?= $userFirstName; ?>" name="txt-first-name" id="txt-first-name" required="required" />
							</div>
						</div>
						<div class="form-group row">
							<label class="col-xl-3 col-lg-3 col-form-label"><?= ucfirst(lang('Profile.field.lastName.label')); ?> <span class="text-danger">*</span></label>
							<div class="col-lg-9 col-xl-9">
								<input class="form-control form-control-lg form-control-solid" type="text" value="<?= $userLastName; ?>" name="txt-last-name" id="txt-last-name" required="required" />
							</div>
						</div>
						<div class="row">
							<label class="col-xl-3"></label>
							<div class="col-lg-9 col-xl-9">
								<h5 class="font-weight-bold mt-10 mb-6"><?= ucfirst(lang('Profile.field.contact.label')); ?></h5>
							</div>
						</div>
						<div class="form-group row">
							<label class="col-xl-3 col-lg-3 col-form-label"><?= ucfirst(lang('Profile.field.phone.label')); ?> <span class="text-danger">*</span></label>
							<div class="col-lg-9 col-xl-9">
								<div class="input-group input-group-lg input-group-solid">
									<div class="input-group-prepend"><span class="input-group-text"><i class="la la-phone"></i></span></div>
									<input type="text" class="form-control form-control-lg form-control-solid" value="<?= $userPhone; ?>" name="txt-phone" id="txt-phone" placeholder="<?= ucfirst(lang('Profile.field.phone.placeholder')); ?>" required="required" />
								</div>
								<span class="form-text text-muted"><?= ucfirst(lang('Profile.field.phone.description')); ?>.</span>
							</div>
						</div>
						<div class="form-group row">
							<label class="col-xl-3 col-lg-3 col-form-label"><?= ucfirst(lang('Profile.field.email.label')); ?> <span class="text-danger">*</span></label>
							<div class="col-lg-9 col-xl-9">
								<div class="input-group input-group-lg input-group-solid">
									<div class="input-group-prepend"><span class="input-group-text"><i class="la la-at"></i></span></div>
									<input type="email" class="form-control form-control-lg form-control-solid" value="<?= $userEmail; ?>" name="txt-email" id="txt-email" placeholder="<?= ucfirst(lang('Profile.field.email.description')); ?>" required="required" />
								</div>
							</div>
						</div>
	        		</div>
		    		<div class="col-xl-2"></div>
				</div>
			</div>
			<!--end::Body-->
		<!-- </form> -->
		<!--end::Form-->

		<div class="card-footer text-right">
			<button type="button" class="btn btn-success" id="<?= $profileButtons['submit']; ?>">
	        	<?= ucfirst(lang('General.action.save')); ?>
	        	<span class="svg-icon">
	        		<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
					    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					        <polygon points="0 0 24 0 24 24 0 24"/>
					        <path d="M9.26193932,16.6476484 C8.90425297,17.0684559 8.27315905,17.1196257 7.85235158,16.7619393 C7.43154411,16.404253 7.38037434,15.773159 7.73806068,15.3523516 L16.2380607,5.35235158 C16.6013618,4.92493855 17.2451015,4.87991302 17.6643638,5.25259068 L22.1643638,9.25259068 C22.5771466,9.6195087 22.6143273,10.2515811 22.2474093,10.6643638 C21.8804913,11.0771466 21.2484189,11.1143273 20.8356362,10.7474093 L17.0997854,7.42665306 L9.26193932,16.6476484 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" transform="translate(14.999995, 11.000002) rotate(-180.000000) translate(-14.999995, -11.000002) "/>
					        <path d="M4.26193932,17.6476484 C3.90425297,18.0684559 3.27315905,18.1196257 2.85235158,17.7619393 C2.43154411,17.404253 2.38037434,16.773159 2.73806068,16.3523516 L11.2380607,6.35235158 C11.6013618,5.92493855 12.2451015,5.87991302 12.6643638,6.25259068 L17.1643638,10.2525907 C17.5771466,10.6195087 17.6143273,11.2515811 17.2474093,11.6643638 C16.8804913,12.0771466 16.2484189,12.1143273 15.8356362,11.7474093 L12.0997854,8.42665306 L4.26193932,17.6476484 Z" fill="#000000" fill-rule="nonzero" transform="translate(9.999995, 12.000002) rotate(-180.000000) translate(-9.999995, -12.000002) "/>
					    </g>
					</svg>
				</span>
	    	</button>
		</div>
	</div>
</form>