<?php

// Namespace to Models folder
namespace App\Models;

// Call BaseModel Namespace
use App\Models\BaseModel;


// begin::RolesPermissionsModel class
class RolesPermissionsModel extends BaseModel
{

    // Model configuration
    protected $table = 'role_permission';
    protected $primaryKey = 'id';

    // Do not use soft delete for this table
    protected $useSoftDeletes = false;
    
    // Allowed fields for insertion
    protected $allowedFields = ['id', 'role_id', 'permission_id'];
    
    // Fields available on SELECT query
    protected $selectedFields = 'role_permission.id, role.id as role_id, role.name as role_name, permission.id as permission_id, permission.name as permission_name, permission.code as permission_code';

    // Fields used on filters queries
    // Used by _getDataBy() function
    protected $filtersFields = [
        'role_id'               => 'role.id',
        'role_name'             => 'role.name',
        'role_active'           => 'role.active',
        'role_deleted'          => 'role.deleted',
        'permission_code'       => 'permission.code',
        'permission_active'     => 'permission.active',
        'permission_deleted'    => 'permission.deleted',
    ];

    // Fields used for SEARCH query
    protected $searchFields = [
    ];

    // Fields available for sorting
    protected $sortingFields = [];

    // Set the joins array
    protected $joints = [
        [
            'table'     => 'role',
            'condition' => 'role.id = role_permission.role_id',
            'type'      => 'inner',
        ],
        [
            'table'     => 'permission',
            'condition' => 'permission.id = role_permission.permission_id',
            'type'      => 'inner',
        ],
    ];

    

    /**
     * RETURN PERMISSIONS CODES
     * FOR A GIVEN ROLE
     * 
     * @param   int    $roleID
     * 
     * @return  array  $permissions_codes
     */
    public function _rolePermissions(int $roleID = 0):?array
    {

        // Check wether an id has been specified or not
        if ($roleID === 0)
        {

            // Returns all the rows availables
            return [];

        } // End if


        /**
         * JOINTS
         * 
         * Set all the joins for the current query
         */
        $this->_setJoints();

        // Return the row details
        return $this->select('permission.code as permission_code')
                    ->asArray()
                    ->where([
                        'role_permission.role_id'   => $roleID,
                        'role.active'               => ACTIVE,
                        'role.deleted'              => INJECTION,
                        'permission.active'         => ACTIVE,
                        'permission.deleted'        => INJECTION,
                    ])
                    ->get()
                    ->getResultArray(); // Return all the items

    } // End function

} // end::RolesPermissionsModel class