<?php

namespace App\Libraries;


/**
 * The Template class
 * @author - XSEL Services <web@xsel-services.com>
 * @date - 31 May, 2022
 * 
 * License Information
 * -------------------------------------------------------------------------------
 * | Permission is hereby granted, free of charge, to any person obtaining a copy
 * | of this software and associated documentation files (the "Software"), to deal
 * | in the Software without restriction, including without limitation the rights
 * | to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * | copies of the Software, and to permit persons to whom the Software is
 * | furnished to do so, subject to the following conditions:
 * |
 * | The above copyright notice and this permission notice shall be included in
 * | all copies or substantial portions of the Software.
 * |
 * | THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * | IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * | FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * | AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * | LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * | OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * | THE SOFTWARE.
 * -------------------------------------------------------------------------------
 */


// Begin Template class
class Template
{

	/**
	 * SET ALL THE PROTECTED VARIABLES
	 */

	protected $defaultTheme = 'default'; // Default theme to display
	protected $pathToThemes = 'theme/'; // Path to the themes layout folders
	protected $templateView;


	//----------------------------------------------------------
	// LOAD A SPECIFIED VIEW CONTENT TO A SELECTED THEME LAYOUT
	//----------------------------------------------------------
		/**
		 * Try to load a view content to a specified
		 * Theme layout using a data array
		 *
		 * @param  string  $content  => path to the page content to display into theme layout (view)
		 * @param  array   $data     => data used in the loaded view as content
		 * @param  string  $theme    => theme to use for displaying layout content
		 *
		 */
		public function render(string $content = '', array $data = [], string $theme = '')
		{

			// Try to the get the theme to display
			// Check whether the path to the theme content is correct or not
			$theme = (! empty($theme)) ? $theme : $this->defaultTheme;

			// Get a new View instance for all the available controllers
			$this->templateView = \Config\Services::renderer();

			// Set all the data required for the following view
			$data['page']	= [
				'menu'			=> $this->templateView->setData($data)->render($this->pathToThemes . $theme . '/_partials/menu'),
				'subHeader'		=> $this->templateView->setData($data)->render($this->pathToThemes . $theme . '/_partials/subHeader'),
				'profilePanel'	=> $this->templateView->setData($data)->render($this->pathToThemes . $theme . '/_partials/profilePanel'),
				'pageContent'	=> $this->templateView->setData($data)->render($content),
				'footer'		=> $this->templateView->setData($data)->render($this->pathToThemes . $theme . '/_partials/footer'),
			];

			// Render the view that corresponds
			print view('theme/default/main', $data);

		} // End function
	//----------------------------------------------------------

} // End Template Library Class