<?php

/**
 * Profile Language File
 */

return [

	/* Informations */
	'title'			=> 'user profile',
	'description'	=> 'view your account informations',


	/* Tabs */
	'tab'		=> [
		'details'	=> [
			'title'			=> 'personal details',
			'description'	=> 'update your profile'
		],
		'password'	=> [
			'title'			=> 'password',
			'description'	=> 'update your password'
		],
	],


	/* Forms */
	'field'			=> [
		'profile'			=> [
			'label'			=> 'profile',
			'description'	=> '',
		],
		'avatar'			=> [
			'label'			=> 'avatar',
			'placeholder'	=> '',
			'description'	=> 'allowed files:  <code>.png</code>, <code>.jpg</code>, <code>.jpeg</code>',
		],
		'firstName'			=> [
			'label'			=> 'first name(s)',
			'placeholder'	=> 'first name(s)',
			'description'	=> 'must contain at least two (2) characters',
			'validation'	=> [
				'required'	=> 'first name(s) is required',
			],
		],
		'lastName'			=> [
			'label'			=> 'last name',
			'placeholder'	=> 'last name',
			'description'	=> 'must contain at least two (2) characters',
			'validation'	=> [
				'required'	=> 'last name is required',
			],
		],
		'company'			=> [
			'label'			=> 'company',
			'description'	=> '',
		],
		'contact'			=> [
			'label'			=> 'contacts',
			'description'	=> '',
		],
		'phone'				=> [
			'label'			=> 'phone number',
			'placeholder'	=> 'phone number',
			'description'	=> 'please specify the country code',
			'validation'	=> [
				'required'	=> 'phone number is required',
				'digits'	=> 'you must enter only digits',
			],
		],
		'email'				=> [
			'label'			=> 'email address',
			'placeholder'	=> 'email address',
			'description'	=> 'must contain at least two (2) characters',
			'validation'	=> [
				'required'	=> 'email address is required',
				'valid'		=> 'the value is not a valid email address',
			],
		],
		'password'			=> [
			'label'			=> 'password',
			'placeholder'	=> 'password',
			'validation'	=> [
				'required'	=> 'password is required',
			],
		],
		'currentPassword'	=> [
			'label'			=> 'current password',
			'placeholder'	=> 'current password',
			'validation'	=> [
				'required'	=> 'current password is required',
			],
		],
		'newPassword'		=> [
			'label'			=> 'new password',
			'placeholder'	=> 'new password',
			'validation'	=> [
				'required'	=> 'new password is required',
			],
		],
		'confirmPassword'	=> [
			'label'			=> 'confirm password',
			'placeholder'	=> 'confirm password',
			'validation'	=> [
				'required'	=> 'please confirm password',
				'match'		=> 'the password and its confirm are not the same',
			],
		],
	],


	/* Actions */
	'action'		=> [
		'editPhoto'		=> 'edit photo',
		'cancelPhoto'	=> 'cancel photo',
		'removePhoto'	=> 'remove photo',
	],


	/* Responses */
	'response'		=> [
		'none'			=> 'none',
		'updated'		=> 'user profile updated',
		'notFound'		=> 'the user you\'ve specified does not exist',
		'incorrectData'	=> 'the data you\'ve specified are not correct'
	],

];

/**
 * End Of File
 */