<?php

namespace App\Controllers;

/**
 * Class BaseController (Not Authenticated)
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 *
 * @package CodeIgniter
 */

use CodeIgniter\Controller;

class NotAuthenticatedBaseController extends Controller
{

	/**
	 * An array of helpers to be loaded automatically upon
	 * class instantiation. These helpers will be available
	 * to all other controllers that extend BaseController.
	 *
	 * @var array
	 */
	protected $helpers = ['url'];

	/**
	 * Constructor.
	 */
	public function initController(\CodeIgniter\HTTP\RequestInterface $request, \CodeIgniter\HTTP\ResponseInterface $response, \Psr\Log\LoggerInterface $logger)
	{
		// Do Not Edit This Line
		parent::initController($request, $response, $logger);

		//--------------------------------------------------------------------
		// Preload any models, libraries, etc, here.
		//--------------------------------------------------------------------
		// E.g.:
		$this->session = \Config\Services::session();

		// Load the project config data as global data
		$this->data['project']	= new \Config\Project;

		// Load the project config data as global data
		$this->project	= new \Config\Project;

		// Try to get the REQUEST locale
		$this->data['locale'] = service('request')->getLocale();

		// Get a new View instance for all the availables controllers
		$this->view = \Config\Services::renderer();


		/*
		* GET ANY VARIABLE THAT COULD BE USED BY ANY OTHER CONTROLLER
		*/
		$sessionToken = $this->session->token;


        /* Localization */
        $generalLanguagePath = "Language/{$this->data['locale']}/General.php";
        $generalLanguageFile = (file_exists(APPPATH . $generalLanguagePath)) ? require_once APPPATH . $generalLanguagePath : '';
        $projectLanguagePath = "Language/{$this->data['locale']}/Project.php";
        $projectLanguageFile = (file_exists(APPPATH . $projectLanguagePath)) ? require_once APPPATH . $projectLanguagePath : '';
        $datesLanguagePath = "Language/{$this->data['locale']}/Dates.php";
        $datesLanguageFile = (file_exists(APPPATH . $datesLanguagePath)) ? require_once APPPATH . $datesLanguagePath : '';

        // Make localization files available through views files
        $this->data['langFile'] = [
            'general'   => $generalLanguageFile,
            'project'   => $projectLanguageFile,
            'dates'     => $datesLanguageFile,
        ];

	}

}
