<?php

namespace App\Controllers;
  
use CodeIgniter\Controller;
use App\Models\UserModel;
use App\Models\RoleModel;
use App\Models\RolePermissionsModel;

use CodeIgniter\I18n\Time;

/**
 * LOAD THE REQUIRED LIBRARIES
 */
use App\Libraries\UtilitiesFunctions; // Layout


// Begin controller function
class Login extends BaseController
{
    // Call index function
    public function index()
    {    
        // Load a helper labrary
        helper(['form']);
        
        // Check if there is no user already connected
        if(! empty($this->session->userSession))
        {
            // Redirect the user to the dashboard controller
            return redirect()->to(base_url('/Home'));
            // return redirect()->route('home');

        } // End if

        // Return login view
        return view('login');

    } // End function
    
  
    // Authentification function
    public function auth()
    {
        // Get a user model instance
        $userModel = new UserModel();
        // Get a role model instance
        $RolePermissionsModel = new RolePermissionsModel();

        // Template Layouts render
        $Fonctions = new UtilitiesFunctions();
        
        // Get the login informations 
        $email = $this->request->getVar('username');
        $password = $this->request->getVar('password');
        
        // Get the informations of user having this email
        $dataEmail = $userModel->where('user.email', $email)->first();
        $dataNumero = $userModel->where('user.numero', $email)->first();

        // var_dump($email);
        // var_dump($dataEmail);
        // var_dump($dataNumero);
        // exit;
        

        // Treat only if exist email
        if($dataNumero || $dataEmail)
        {   
            // Get the informations
            $data = (! empty($dataNumero)) ? $dataNumero : $dataEmail;

            $rondonSalt = (! empty($data) && ! empty($data['random_salt'])) ? $data['random_salt'] : '';
            $new_pwd = $userModel->hashPasswd($password, $rondonSalt);
            // var_dump($new_pwd);
            // var_dump($rondonSalt);
            // exit;

            // Get the informations of user having this email
            $where  = [
                'user.active' => 1,
                'user.password' => $new_pwd
            ];

            $or_where  = [
                'user.email' => $email,
                'user.numero' => $email,
            ];
            
            // Define the fields to be selected
            $allowedFields = ['user.id', 'user.active'];

            // Returns all the rows availables
           $row = $userModel->select($allowedFields)
                             ->groupStart()
                                ->orWhere($or_where)
                             ->groupEnd()
                             ->where($where)
                             ->get()
                             ->getResultArray();
            
            // Get user ID
            $userID = (! empty($row) && ! empty($row[0]['id'])) ? $row[0]['id'] : 0;

            // Treat only if password is correct
            if(! empty($row))
            {   
                // Get all informations for the user
                $userData = $userModel->GetUserConnectedInfos($userID);

                // Get user permissions
                $permissions = $RolePermissionsModel->getAllUserPermissions($userData['roleID']);

                $expiration = ( ! empty($Fonctions->expired($userData['expiration'])) && $Fonctions->expired($userData['expiration']) !== null) ? $Fonctions->expired($userData['expiration']): '' ;

                // var_dump($userData);
                // var_dump($expiration);
                // var_dump($permissions);
                // exit;
                
                if(empty($expiration) || ! $expiration['expired'])
                {
                    // Define the array data
                    $ses_data = [
                        'id'            => $userData['id'],
                        'firstName'     => $userData['firstName'],
                        'lastName'      => $userData['lastName'],
                        'email'         => $userData['email'],
                        'role'          => $userData['role'],
                        'roleID'        => $userData['roleID'],
                        'number'        => $userData['numero'],
                        'photo'         => $userData['photo'],
                        'filePath'      => $userData['filePath'],
                        'logged_in'     => TRUE,
                        'permissions'    => $permissions,
                    ];

                    // var_dump($ses_data);
                    // exit;
                    
                    // Create session and add the array data
                    $this->session->set('userSession', $ses_data);

                    // Set the right return value
                    $type = 'success';
                    $message = 'Bienvenue '.$userData['lastName'] .' '.$userData['firstName'];

                }// End If
                else
                {
                    // Set the right return value
                    $type = 'danger';
                    $message = 'Votre compte est expiré.';

                }// End Else

            }// End If
            else
            {
                // Set the right return value
                $type = 'danger';
                $message = 'Mot de passe incorrect.';

            }// End Else

        }// End If
        else
        {
            // Set the right return value
            $type = 'warning';
            $message = 'Cet identifiant n\'est pas valide.';

        }// End Else

        // Set the response
        $response = [
            'type'      => $type,
            'message'   => $message,
        ];

        // var_dump($response);
        // exit;

        // Return the response
        echo json_encode($response);

    }// End function
  


    // --------------------
    // LOGOUT USER FUNCTION
    // --------------------
        public function logout()
        {
            $this->session->destroy();
            return redirect()->to('/login');
        }
    // --------------------

    //------------------------------------------------
    // DISPLAY THE PASSWORD RECOVERY FORM TO THE USER
    //------------------------------------------------
        public function pwd_reset($recovery_code = '')
        {
            // Check wether the user is already connected or not
            if(! empty($this->session->userSession))
            {
                // Redirect the user to the login controller
                return redirect()->to(base_url('home'));

            } // End if

            // Recevoir n'importe quel code_de_rétablissement envoyé
            $recovery_code = ( ! empty($recovery_code)) ? trim($recovery_code) : '';

            // Traiter seulement s'il y a un code_de_récupération envoyé
            if( ! empty($recovery_code))
            {
                // Get a user model instance
                $userModel = new UserModel();

                // Get user informations with recovery cod
                $userData = $userModel->GetUserRecoveryInfos($recovery_code);
                
                // Obtenir le retour de l'identifiant de l'utilisateur
                $userId = ( ! empty($userData['id'])) ? $userData['id']: '';

                // Traiter uniquement si un utilisateur a été sélectionné
                if( ! empty($userId))
                {
                    // Obtenir le nom et le prénom de l'utilisateur
                    $user_first_name = ( ! empty($userData['firstName'])) ? ucwords($userData['firstName']) : '';
                    $user_last_name = ( ! empty($userData['lastName'])) ? mb_strtoupper($userData['lastName']) : '';
                    $pwd_recovery_date = ( ! empty($userData['pwd_date_recuperation'])) ? trim($userData['pwd_date_recuperation']) : '';

                    // Définir la date d'expiration de la récupération du mot de passe
                    $timeObjecteDate = Time::parse($pwd_recovery_date, 'Africa/Abidjan');
                    $time = $timeObjecteDate->addHours(24); //Ajouter 24 heures à partir de la récupération DateTime
                    $pwd_expire_recovery_date = $time->toDateTimeString();// Obtenir le nouveau formatage de DateTime

                    // Template Layouts render
                    $Fonctions = new UtilitiesFunctions();

                    // Vérifier si le code_de_rétablissement est toujours valide
                    $recovery_code_has_expired = ($pwd_recovery_date !== null) ? $Fonctions->expired($pwd_expire_recovery_date) : '';

                    // Traiter uniquement si le code_de_récupération actuel n'a pas encore expiré
                    if(empty($recovery_code_has_expired) || ! $recovery_code_has_expired['expired'])
                    {
                        // Code de récupération
                        $this->data['recovery_code']    = $recovery_code;

                        // Définissez toutes les données sur la vue suivante
                        $this->data['user_id']          = $userId;
                        $this->data['user_first_name']  = $user_first_name;
                        $this->data['user_last_name']   = $user_last_name;

                    } // FinSi
                    else
                    {
                        // Régler la bonne valeur de retour
                        $return = [
                            'severity'  => 'warning',
                            'message'   => 'votre lien d\'activation n\'est plus valable, veuillez faire une nouvelle demande.'
                        ];

                    } // Fin si

                } // Fin si
                else
                {

                    // Régler la bonne valeur de retour
                    $return = [
                        'severity'  => 'danger',
                        'message'   => 'ce lien d\'activation n\'est pas valable, veuillez faire une demande de réinitialisation.'
                    ];

                } //Finsinon
            } //FinSi
            else
            {

                // Régler la bonne valeur de retour
                $return = [
                    'severity'  => 'info',
                    'message'   => 'veuillez cliquer sur <code>Mot de passe oublié</code> si vous avez perdu votre mot de passe.'
                ];

            } // Finsi

            // var_dump($return);
            // // var_dump($return);
            // exit;

            // Traiter uniquement si le message send_back n'est pas vide
            if( ! empty($return))
            {

                // Définir le message de retour en arrière
                $this->session->setFlashdata('return', $return);

                // Rediriger l'utilisateur vers le formulaire d'authentification
                return redirect()->to(base_url('login'));

            } // Finsi

            // Charger la vue d'authentification
            // Load the page content
            echo view('recovery', $this->data);
            // $return view('recovery', $this->data);
            // $this->load->view('recovery', $this->data);

        } // fin de la fonction
    //------------------------------------------------




    
    //--------------------------------------
    // GENERATE A LINK FOR PASSWORD RECOVERY
    //--------------------------------------
        public function pwdRecovery()
        {
            // Essayez de recevoir l'email du compte envoyé
            $UserEmail  = ( ! empty($this->request->getPost('email'))) ? trim($this->request->getPost('email')) : '';

            // var_dump($_POST);
            // var_dump($email);
            // exit;

            // Traiter seulement si des données ont été fournies
            if( ! empty($UserEmail))
            {   
                // Get a user model instance
                $userModel = new UserModel();

                // Get the informations of user having this email
                $existUser = $userModel->where('user.email', $UserEmail)->first();

                // var_dump($existUser);
                // exit;

                // Obtenir le retour de l'identifiant de l'utilisateur
                $userId = ( ! empty($existUser['id'])) ? $existUser['id'] : '';

                // Traiter uniquement si un utilisateur a été sélectionné
                if( ! empty($userId))
                {
                    // Get all informations for the user
                    $userData = $userModel->GetUserConnectedInfos($userId);

                    // Obtenir le nom et le prénom de l'utilisateur
                    $user_first_name = ( ! empty($userData['firstName'])) ? ucwords($userData['firstName']) : '';
                    $user_last_name = ( ! empty($userData['lastName'])) ? mb_strtoupper($userData['lastName']) : '';
                    $pwd_recovery_date = ( ! empty($userData['pwd_date_recuperation'])) ? trim($userData['pwd_date_recuperation']) : '';

                    // Générer une nouvelle valeur de code_de_récupération
                    $recovery_code = ($userModel->_randomSalt()).''.time();

                    // Définir le lien de récupération
                    $recovery_link = site_url('login/pwd_reset/'.$recovery_code);

                    // Obtenir l'heure actuelle de DateTime
                    $recovery_date = date("Y-m-d H:i:s");

                    //-------------------------------------------------------
                    // METTRE À JOUR LE CODE DE RÉCUPÉRATION DE L'UTILISATEUR
                    //-------------------------------------------------------

                       // Update the Utilisateur
                        $updated = $userModel->update($userId, [
                            'user.pwd_code_recuperation' => $recovery_code,
                            'user.pwd_date_recuperation' => $recovery_date
                        ]);
                    //-----------------------------


                    // Create and compose the "recovery link" mail
                    $message = 'Bonjour Monsieur/Madame ' . $user_first_name . ' ' . $user_last_name . ',<br/>';
                    $message .= 'vous recevez ce message car vous avez demandé à réinitialiser votre mot de passe.<br/>';
                    $message .= 'Si tel est le cas, nous vous invitons à suivre le <a target="_blank" href="' . $recovery_link . '">lien de récupération</a> ou alors de copier puis coller le lien ci-dessous dans la barre d\'adresse de votre navigateur.<br/>';
                    $message .= '<u><strong>' . $recovery_link . '</strong></u><br/><br/>';
                    $message .= 'Si vous n\'êtes par contre pas à l\'origine de cette demande veuillez ignorer ces instructions!<br/>';
                    $message .= '<strong>Ce message s\'autodétruira dans 24 heures...</strong><br/><br/>';
                    $message .= 'Cordialement,<br/>BLCNTS.';
                    
                    $email = \Config\Services::email();
                    $email->setFrom('admin@xsel-ci.com', 'BLCNTS');
                    $email->setTo($UserEmail);
                    $email->setSubject('Récupération de mot de passe | BLCNTS');
                    $email->setMessage($message);//your message here
                    $email->send();

                    // égler la bonne valeur de retour
                    $type = 'success';
                    $message = 'Un email contenant les instructions de récupération vous a été envoyé, veuillez consulter votre messagerie électronique.';

                } // FinSi
                else
                {

                    // Régler la bonne valeur de retour
                    $type = 'warning';
                    $message = 'Cette adresse email n\'est pas valide.';

                } // Fin sinon

            } // Finsi
            else
            {

                // égler la bonne valeur de retour
                $type = 'info';
                $message = 'Veuillez entrer des informations valides.';

            } //Fin sinon
            
            // Set the response
            $response = [
                'type'      => $type,
                'message'   => $message,
            ];

            // var_dump($response);
            // exit;

            // Return the response
            echo json_encode($response);


        } // fin de la fonction
    //--------------------------------------
    



    //--------------------------
    // UPDATE THE USER PASSWORD
    //--------------------------
        public function setPassword()
        {
             // var_dump($_POST);
             // exit; 
             
            // Process only if there is any data posted
            if( ! empty($_POST))
            {
                // Get all the sent informations
                $new_pwd = ( ! empty($this->request->getPost('txt-pwd'))) ? $this->request->getPost('txt-pwd') : '';
                $new_pwd_confirmed = ( ! empty($this->request->getPost('txt-repeated-pwd'))) ? $this->request->getPost('txt-repeated-pwd') : '';
                $recovery_code = ( ! empty($this->request->getPost('hd-code'))) ? $this->request->getPost('hd-code') : '';

                // Get a user model instance
                $userModel = new UserModel();


                // Check if all the required data are availables
                if( ! empty($new_pwd) && ! empty($new_pwd_confirmed) && ! empty($recovery_code))
                {
                    // Process only if the sent new passwords are the same
                    if($new_pwd === $new_pwd_confirmed)
                    {
                        // Get encrypted the new user password
                        $new_random_salt   = $userModel->_randomSalt();
                        $encrypted_new_pwd = $userModel->hashPasswd($new_pwd, $new_random_salt);

                        // Get the informations of user having this email
                        $existUser = $userModel->where('user.pwd_code_recuperation', $recovery_code)->first();

                        // Obtenir le retour de l'identifiant de l'utilisateur
                        $userId = ( ! empty($existUser['id'])) ? $existUser['id'] : '';

                        // var_dump($userId);
                        // var_dump($new_random_salt);
                        // var_dump($encrypted_new_pwd);
                        // exit;
                        
                        // Update the Utilisateur
                        $updated = $userModel->update($userId, [
                            'user.random_salt'           => $new_random_salt,
                            'user.password'              => $encrypted_new_pwd,
                            'user.pwd_code_recuperation' => ''
                        ]);

                        // Process only if the user account has been successfully updated
                        if($updated)
                        {
                            // Set the right return value
                            $type = 'success';
                            $message = 'votre mot de passe a &eacute;t&eacute; correctement mis &agrave; jour';

                        } // End if
                        else
                        {
                            // Set the right return value
                            $type = 'danger';
                            $message = 'impossible de mettre &agrave; jour le mot de passe, une erreur est survenue.';

                        } // End else

                    } // End if
                    else
                    {
                        // Set the right return value
                        $type = 'warning';
                        $message = 'Les mots de passe entr&eacute;s ne sont pas identiques.';

                    } // End else

                } // End if
                else
                {
                    // Set the right return value
                    $type = 'danger';
                    $message = 'Veuillez renseigner tous les champs obligatoires correctement.';

                } // End else

            } // End if

            // Set the response
            $response = [
                'type'      => $type,
                'message'   => $message,
            ];

            // Return the response
            echo json_encode($response);


        } // End function
    //--------------------------




} // End function